/*
 * Decompiled with CFR 0.152.
 */
package org.sheinbergon.aac.encoder.util;

import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AACEncodingChannelMode {
    MODE_INVALID(-1, -1),
    MODE_1(1, 1),
    MODE_2(2, 2),
    MODE_1_2(3, 3),
    MODE_1_2_1(4, 4),
    MODE_1_2_2(5, 5),
    MODE_1_2_2_1(6, 6);

    private static final Map<Integer, AACEncodingChannelMode> countToEnumMap;
    private final int count;
    private final int mode;

    public static AACEncodingChannelMode valueOf(int count) {
        return countToEnumMap.getOrDefault(count, MODE_INVALID);
    }

    public int getCount() {
        return this.count;
    }

    public int getMode() {
        return this.mode;
    }

    private AACEncodingChannelMode(int count, int mode) {
        this.count = count;
        this.mode = mode;
    }

    static {
        countToEnumMap = Stream.of(AACEncodingChannelMode.values()).collect(Collectors.toMap(AACEncodingChannelMode::getCount, facm -> facm));
    }
}

