/*
 * Decompiled with CFR 0.152.
 */
package org.sheinbergon.aac.encoder;

import com.sun.jna.Memory;
import com.sun.jna.ptr.IntByReference;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import org.sheinbergon.aac.encoder.AACAudioOutput;
import org.sheinbergon.aac.encoder.WAVAudioInput;
import org.sheinbergon.aac.encoder.util.AACAudioEncoderException;
import org.sheinbergon.aac.encoder.util.AACEncodingChannelMode;
import org.sheinbergon.aac.encoder.util.AACEncodingProfile;
import org.sheinbergon.aac.jna.FdkAACLibFacade;
import org.sheinbergon.aac.jna.structure.AACEncBufDesc;
import org.sheinbergon.aac.jna.structure.AACEncInArgs;
import org.sheinbergon.aac.jna.structure.AACEncInfo;
import org.sheinbergon.aac.jna.structure.AACEncOutArgs;
import org.sheinbergon.aac.jna.structure.AACEncoder;
import org.sheinbergon.aac.jna.util.AACEncParam;

@NotThreadSafe
public class AACAudioEncoder
implements AutoCloseable {
    private static final Set<Integer> SAMPLE_RATES = Set.of(Integer.valueOf(16000), Integer.valueOf(22050), Integer.valueOf(24000), Integer.valueOf(32000), Integer.valueOf(44100), Integer.valueOf(48000));
    private static final int PARAMETRIC_STEREO_CHANNEL_COUNT = 2;
    private static final int ADTS_TRANSMUX = 2;
    private static final int WAV_INPUT_CHANNEL_ORDER = 1;
    private static final int MAX_ENCODER_CHANNELS = 0;
    private static final int ENCODER_MODULES_MASK = 0;
    private static final int OUT_BUFFER_SIZE = 20480;
    private final AACEncoder encoder;
    private final int inputBufferSize;
    private final Memory inBuffer;
    private final Memory outBuffer;
    private final AACEncInArgs inArgs;
    private final AACEncOutArgs outArgs;
    private final AACEncBufDesc inBufferDescriptor;
    private final AACEncBufDesc outBufferDescriptor;
    private volatile boolean closed = false;

    private AACAudioEncoder(AACEncoder encoder, AACEncInfo info) {
        this.encoder = encoder;
        this.inputBufferSize = info.inputChannels * info.frameLength * 2;
        this.inBuffer = new Memory((long)this.inputBufferSize);
        this.outBuffer = new Memory(20480L);
        this.inArgs = new AACEncInArgs();
        this.outArgs = new AACEncOutArgs();
        this.inBufferDescriptor = FdkAACLibFacade.inBufferDescriptor(this.inBuffer);
        this.outBufferDescriptor = FdkAACLibFacade.outBufferDescriptor(this.outBuffer);
        this.disableStructureSynchronization();
    }

    public static Builder builder() {
        return new Builder();
    }

    public final AACAudioOutput encode(WAVAudioInput input) throws AACAudioEncoderException {
        this.verifyState();
        try {
            int read;
            AACAudioOutput.Accumulator accumulator = AACAudioOutput.accumulator();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(input.data());
            byte[] buffer = new byte[this.inputBufferSize()];
            while ((read = inputStream.read(buffer)) != -1) {
                this.populateInputBuffer(buffer, read);
                byte[] encoded = FdkAACLibFacade.encode(this.encoder, this.inBufferDescriptor, this.outBufferDescriptor, this.inArgs, this.outArgs, read).orElseThrow(() -> new IllegalStateException("No encoded audio data returned"));
                accumulator.accumulate(encoded);
            }
            return accumulator.done();
        }
        catch (IOException | RuntimeException x) {
            throw new AACAudioEncoderException("Could not encode WAV audio to AAC audio", x);
        }
    }

    public final AACAudioOutput conclude() throws AACAudioEncoderException {
        this.verifyState();
        try {
            Optional<byte[]> optional;
            this.inBufferDescriptor.clear();
            AACAudioOutput.Accumulator accumulator = AACAudioOutput.accumulator();
            while ((optional = FdkAACLibFacade.encode(this.encoder, this.inBufferDescriptor, this.outBufferDescriptor, this.inArgs, this.outArgs, -1)).isPresent()) {
                accumulator.accumulate(optional.get());
            }
            AACAudioOutput aACAudioOutput = accumulator.done();
            return aACAudioOutput;
        }
        catch (RuntimeException x) {
            throw new AACAudioEncoderException("Could not conclude WAV audio to AAC audio", x);
        }
        finally {
            this.close();
        }
    }

    private void populateInputBuffer(byte[] buffer, int size) {
        this.inBuffer.write(0L, buffer, 0, size);
        if (size != this.inputBufferSize) {
            this.inBufferDescriptor.bufSizes = new IntByReference(size);
            this.inBufferDescriptor.writeField("bufSizes");
        }
    }

    private void disableStructureSynchronization() {
        this.encoder.write();
        this.encoder.setAutoSynch(false);
        this.inBufferDescriptor.write();
        this.inBufferDescriptor.setAutoSynch(false);
        this.outBufferDescriptor.write();
        this.outBufferDescriptor.setAutoSynch(false);
        this.inArgs.setAutoSynch(false);
        this.outArgs.setAutoSynch(false);
    }

    private void verifyState() {
        if (this.closed) {
            throw new AACAudioEncoderException("Encoder instance already closed");
        }
    }

    @Override
    public void close() {
        if (!this.closed) {
            FdkAACLibFacade.closeEncoder(this.encoder);
            this.closed = true;
        }
    }

    public int inputBufferSize() {
        return this.inputBufferSize;
    }

    public static class Builder {
        private static final Map<AACEncodingProfile, Float> SAMPLES_TO_BIT_RATE_RATIO = Map.of(AACEncodingProfile.AAC_LC, Float.valueOf(1.5f), AACEncodingProfile.HE_AAC, Float.valueOf(0.625f), AACEncodingProfile.HE_AAC_V2, Float.valueOf(0.5f));
        private boolean afterBurner = true;
        private AACEncodingProfile profile = AACEncodingProfile.AAC_LC;
        private int channels = 2;
        private int sampleRate = 44100;

        private void setEncoderParams(AACEncoder encoder) {
            FdkAACLibFacade.setEncoderParam(encoder, AACEncParam.AACENC_AFTERBURNER, this.afterBurner ? 1 : 0);
            FdkAACLibFacade.setEncoderParam(encoder, AACEncParam.AACENC_SAMPLERATE, this.sampleRate);
            FdkAACLibFacade.setEncoderParam(encoder, AACEncParam.AACENC_BITRATE, this.deduceBitRate());
            FdkAACLibFacade.setEncoderParam(encoder, AACEncParam.AACENC_TRANSMUX, 2);
            FdkAACLibFacade.setEncoderParam(encoder, AACEncParam.AACENC_AOT, this.profile.getAot());
            FdkAACLibFacade.setEncoderParam(encoder, AACEncParam.AACENC_CHANNELORDER, 1);
            FdkAACLibFacade.setEncoderParam(encoder, AACEncParam.AACENC_CHANNELMODE, AACEncodingChannelMode.valueOf(this.channels).getMode());
        }

        private int deduceBitRate() {
            return (int)((float)(this.channels * this.sampleRate) * SAMPLES_TO_BIT_RATE_RATIO.get((Object)this.profile).floatValue());
        }

        public AACAudioEncoder build() {
            if (!SAMPLE_RATES.contains(this.sampleRate)) {
                throw new AACAudioEncoderException("sampleRate", this.sampleRate);
            }
            if (AACEncodingChannelMode.valueOf(this.channels) == AACEncodingChannelMode.MODE_INVALID) {
                throw new AACAudioEncoderException("channels", this.channels);
            }
            if (this.profile == AACEncodingProfile.HE_AAC_V2 && this.channels != 2) {
                throw new AACAudioEncoderException("HE-AACv2 only supports 2 channels (stereo) mode");
            }
            AACEncoder encoder = FdkAACLibFacade.openEncoder(0, 0);
            this.setEncoderParams(encoder);
            FdkAACLibFacade.initEncoder(encoder);
            AACEncInfo info = FdkAACLibFacade.getEncoderInfo(encoder);
            return new AACAudioEncoder(encoder, info);
        }

        public Builder afterBurner(boolean afterBurner) {
            this.afterBurner = afterBurner;
            return this;
        }

        public Builder profile(AACEncodingProfile profile) {
            this.profile = profile;
            return this;
        }

        public Builder channels(int channels) {
            this.channels = channels;
            return this;
        }

        public Builder sampleRate(int sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        private Builder() {
        }
    }
}

