/*
 * Decompiled with CFR 0.152.
 */
package org.sheinbergon.aac.jna;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.sheinbergon.aac.jna.FdkAACLib;
import org.sheinbergon.aac.jna.structure.AACEncBufDesc;
import org.sheinbergon.aac.jna.structure.AACEncInArgs;
import org.sheinbergon.aac.jna.structure.AACEncInfo;
import org.sheinbergon.aac.jna.structure.AACEncOutArgs;
import org.sheinbergon.aac.jna.structure.AACEncoder;
import org.sheinbergon.aac.jna.util.AACEncError;
import org.sheinbergon.aac.jna.util.AACEncParam;
import org.sheinbergon.aac.jna.util.FdkAACLibException;
import org.sheinbergon.aac.jna.util.JNASupport;

public final class FdkAACLibFacade {
    private static final int IN_BUFFER_COUNT = 1;
    private static final int IN_BUFFER_IDENTIFIER = 0;
    private static final int IN_BUFFER_ELEMENT_SIZE = 2;
    private static final int IN_SAMPLES_DIVISOR = 2;
    private static final int OUT_BUFFER_COUNT = 1;
    private static final int OUT_BUFFER_IDENTIFIER = 3;
    private static final int OUT_BUFFER_ELEMENT_SIZE = 1;

    public static AACEncoder openEncoder(int modules, int maxChannels) {
        PointerByReference pointerRef = new PointerByReference();
        AACEncError result = AACEncError.valueOf(FdkAACLib.aacEncOpen(pointerRef, modules, maxChannels));
        FdkAACLibFacade.verifyResult(result, FdkAACLib.Functions.OPEN);
        return AACEncoder.of(pointerRef);
    }

    public static void closeEncoder(@Nonnull AACEncoder encoder) {
        PointerByReference pointerRef = new PointerByReference(encoder.getPointer());
        AACEncError result = AACEncError.valueOf(FdkAACLib.aacEncClose(pointerRef));
        FdkAACLibFacade.verifyResult(result, FdkAACLib.Functions.CLOSE);
    }

    public static void initEncoder(@Nonnull AACEncoder encoder) {
        AACEncError result = AACEncError.valueOf(FdkAACLib.aacEncEncode(encoder, null, null, null, null));
        FdkAACLibFacade.verifyResult(result, FdkAACLib.Functions.ENCODE);
    }

    public static Optional<byte[]> encode(@Nonnull AACEncoder encoder, @Nonnull AACEncBufDesc inBufferDescriptor, @Nonnull AACEncBufDesc outBufferDescriptor, @Nonnull AACEncInArgs inArgs, @Nonnull AACEncOutArgs outArgs, int size) {
        JNASupport.clearStructureMemory(inArgs, outArgs);
        inArgs.numInSamples = size == -1 ? size : size / 2;
        inArgs.writeField("numInSamples");
        return Optional.ofNullable(AACEncError.valueOf(FdkAACLib.aacEncEncode(encoder, inBufferDescriptor, outBufferDescriptor, inArgs, outArgs))).filter(result -> result != AACEncError.AACENC_ENCODE_EOF).map(result -> {
            outArgs.readField("numOutBytes");
            FdkAACLibFacade.verifyResult(result, FdkAACLib.Functions.ENCODE);
            return outBufferDescriptor.bufs.getValue().getByteArray(0L, outArgs.numOutBytes);
        });
    }

    public static AACEncInfo getEncoderInfo(@Nonnull AACEncoder encoder) {
        AACEncInfo info = new AACEncInfo();
        AACEncError result = AACEncError.valueOf(FdkAACLib.aacEncInfo(encoder, info));
        FdkAACLibFacade.verifyResult(result, FdkAACLib.Functions.INFO);
        info.read();
        return info;
    }

    public static void setEncoderParam(@Nonnull AACEncoder encoder, @Nonnull AACEncParam param, int value) {
        AACEncError result = AACEncError.valueOf(FdkAACLib.aacEncoder_SetParam(encoder, param.getValue(), value));
        FdkAACLibFacade.verifyResult(result, FdkAACLib.Functions.SET_PARAM);
    }

    private static void verifyResult(@Nonnull AACEncError result, @Nonnull FdkAACLib.Functions function) {
        Optional.of(result).filter(error -> !error.equals((Object)AACEncError.AACENC_OK)).ifPresent(error -> {
            throw new FdkAACLibException((AACEncError)((Object)error), function.libraryFunctionName());
        });
    }

    public static AACEncBufDesc outBufferDescriptor(@Nonnull Memory buffer) {
        AACEncBufDesc descriptor = new AACEncBufDesc();
        descriptor.numBufs = 1;
        descriptor.bufs = new PointerByReference((Pointer)buffer);
        descriptor.bufSizes = new IntByReference((int)buffer.size());
        descriptor.bufferIdentifiers = new IntByReference(3);
        descriptor.bufElSizes = new IntByReference(1);
        descriptor.write();
        return descriptor;
    }

    public static AACEncBufDesc inBufferDescriptor(@Nonnull Memory buffer) {
        AACEncBufDesc descriptor = new AACEncBufDesc();
        descriptor.numBufs = 1;
        descriptor.bufs = new PointerByReference((Pointer)buffer);
        descriptor.bufSizes = new IntByReference((int)buffer.size());
        descriptor.bufferIdentifiers = new IntByReference(0);
        descriptor.bufElSizes = new IntByReference(2);
        descriptor.write();
        return descriptor;
    }

    private FdkAACLibFacade() {
    }
}

