/*
 * Decompiled with CFR 0.152.
 */
package org.sheinbergon.aac.encoder;

import javax.annotation.Nonnull;
import org.apache.commons.lang3.ArrayUtils;

public class AACAudioOutput {
    private final byte[] data;
    private final int length;

    @Nonnull
    public static Accumulator accumulator() {
        return new Accumulator();
    }

    public byte[] data() {
        return this.data;
    }

    public int length() {
        return this.length;
    }

    private AACAudioOutput(byte[] data, int length) {
        this.data = data;
        this.length = length;
    }

    static class Accumulator {
        private byte[] data = null;
        private int length = 0;

        void accumulate(@Nonnull byte[] bytes) {
            if (bytes.length != 0) {
                this.data = ArrayUtils.addAll((byte[])this.data, (byte[])bytes);
                this.length += bytes.length;
            }
        }

        AACAudioOutput done() {
            return new AACAudioOutput(this.data, this.length);
        }

        private Accumulator() {
        }
    }
}

