/*
 * Decompiled with CFR 0.152.
 */
package org.sheinbergon.aac.encoder;

import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.ArrayUtils;
import org.sheinbergon.aac.encoder.util.WAVAudioFormat;
import org.sheinbergon.aac.encoder.util.WAVAudioInputException;

public class WAVAudioInput {
    private static final WAVAudioFormat SUPPORTED_AUDIO_FORMATS = WAVAudioFormat.PCM;
    private final byte[] data;

    @Nonnull
    public static WAVAudioInput pcms16le(byte[] data, int length) {
        return WAVAudioInput.builder().audioFormat(WAVAudioFormat.PCM).endianness(ByteOrder.LITTLE_ENDIAN).sampleSize(16).data(data).length(length).build();
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    public byte[] data() {
        return this.data;
    }

    private WAVAudioInput(byte[] data) {
        this.data = data;
    }

    public static class Builder {
        private byte[] data = null;
        private int length = 0;
        private int sampleSize = 0;
        private ByteOrder endianness = null;
        private WAVAudioFormat audioFormat = null;

        @Nonnull
        public WAVAudioInput build() {
            if (ArrayUtils.isEmpty((byte[])this.data)) {
                throw new WAVAudioInputException("data", "Empty/Null array");
            }
            if (this.length < 0 || this.length > this.data.length) {
                throw new WAVAudioInputException("length", String.valueOf(this.length));
            }
            if (this.sampleSize != 16) {
                throw new WAVAudioInputException("sampleSize", String.valueOf(this.sampleSize));
            }
            if (!Objects.equals((Object)this.audioFormat, (Object)WAVAudioFormat.PCM)) {
                throw new WAVAudioInputException("audioFormat", String.valueOf((Object)this.audioFormat));
            }
            if (!Objects.equals(this.endianness, ByteOrder.LITTLE_ENDIAN)) {
                throw new WAVAudioInputException("endianness", String.valueOf(this.endianness));
            }
            return new WAVAudioInput(Arrays.copyOf(this.data, this.length));
        }

        public Builder data(byte[] data) {
            this.data = data;
            return this;
        }

        public Builder length(int length) {
            this.length = length;
            return this;
        }

        public Builder sampleSize(int sampleSize) {
            this.sampleSize = sampleSize;
            return this;
        }

        public Builder endianness(ByteOrder endianness) {
            this.endianness = endianness;
            return this;
        }

        public Builder audioFormat(WAVAudioFormat audioFormat) {
            this.audioFormat = audioFormat;
            return this;
        }

        private Builder() {
        }
    }
}

