/*
 * Decompiled with CFR 0.152.
 */
package org.sheinbergon.needle.concurrent;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sheinbergon.needle.AffinityDescriptor;
import org.sheinbergon.needle.PinnedThread;
import org.sheinbergon.needle.concurrent.PinnedThreadFactory;
import org.sheinbergon.needle.concurrent.util.ResettableOneOffLatch;

public final class GovernedAffinityPinnedThreadFactory
implements PinnedThreadFactory {
    @Nonnull
    private final Set<PinnedThread> governed = Sets.newHashSet();
    @Nonnull
    private final Lock accessLock = new ReentrantLock();
    @Nonnull
    private final ResettableOneOffLatch pinnedThreadStartLatch = new ResettableOneOffLatch();
    @Nullable
    private volatile AffinityDescriptor affinity;

    public GovernedAffinityPinnedThreadFactory() {
    }

    public GovernedAffinityPinnedThreadFactory(@Nonnull AffinityDescriptor affinityDescriptor) {
        this.affinity = affinityDescriptor;
    }

    public int governed() {
        this.pinnedThreadStartLatch.await(false);
        AtomicInteger size = new AtomicInteger();
        this.safe(() -> size.set(this.governed.size()));
        return size.get();
    }

    public void alter(@Nonnull AffinityDescriptor affinityDescriptor, boolean affectGoverned) {
        this.affinity = affinityDescriptor;
        if (affectGoverned) {
            this.alter(pinned -> pinned.affinity(affinityDescriptor));
        }
    }

    @Override
    public PinnedThread newThread(@Nonnull Runnable r) {
        this.pinnedThreadStartLatch.await(true);
        PinnedThread pinned = this.pinned(r);
        this.safe(() -> this.governed.add(pinned));
        return pinned;
    }

    private void safe(@Nonnull Runnable action) {
        this.accessLock.lock();
        try {
            action.run();
        }
        finally {
            this.accessLock.unlock();
        }
    }

    private PinnedThread pinned(@Nonnull Runnable r) {
        if (this.affinity != null) {
            return new GovernedPinnedThread(r, this.affinity);
        }
        return new GovernedPinnedThread(r);
    }

    private void alter(@Nonnull Consumer<PinnedThread> fn) {
        this.pinnedThreadStartLatch.await(false);
        this.safe(() -> this.governed.forEach(fn));
    }

    private final class GovernedPinnedThread
    extends PinnedThread {
        GovernedPinnedThread(@Nonnull Runnable target, AffinityDescriptor descriptor) {
            super(target, descriptor);
        }

        GovernedPinnedThread(Runnable target) {
            super(target);
        }

        public void run() {
            try {
                GovernedAffinityPinnedThreadFactory.this.pinnedThreadStartLatch.fire();
                super.run();
            }
            finally {
                GovernedAffinityPinnedThreadFactory.this.safe(() -> GovernedAffinityPinnedThreadFactory.this.governed.remove((Object)this));
            }
        }
    }
}

