/*
 * Decompiled with CFR 0.152.
 */
package org.sheinbergon.needle.concurrent;

import java.io.Closeable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.math.NumberUtils;
import org.sheinbergon.needle.concurrent.PinnedThreadFactory;

public final class PinnedThreadPoolExecutor
extends ThreadPoolExecutor
implements Closeable {
    public PinnedThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, @Nonnull TimeUnit unit, @Nonnull BlockingQueue<Runnable> workQueue, @Nonnull PinnedThreadFactory factory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, factory);
    }

    public static ExecutorService newSinglePinnedThreadExecutor(@Nonnull PinnedThreadFactory factory) {
        return new PinnedThreadPoolExecutor((int)NumberUtils.INTEGER_ONE, (int)NumberUtils.INTEGER_ONE, (long)NumberUtils.LONG_ZERO, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), factory);
    }

    public static ExecutorService newFixedPinnedThreadPool(int size, @Nonnull PinnedThreadFactory factory) {
        return new PinnedThreadPoolExecutor(size, size, (long)NumberUtils.LONG_ZERO, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), factory);
    }

    @Override
    public void close() {
        this.shutdown();
    }
}

