/*
 * Decompiled with CFR 0.152.
 */
package org.sheinbergon.needle.concurrent;

import com.google.common.collect.Sets;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sheinbergon.needle.AffinityDescriptor;
import org.sheinbergon.needle.Pinned;
import org.sheinbergon.needle.PinnedThread;
import org.sheinbergon.needle.concurrent.PinnedThreadFactory;
import org.sheinbergon.needle.concurrent.util.ResettableOneOffLatch;

public final class GovernedAffinityPinnedThreadFactory
implements PinnedThreadFactory {
    @Nonnull
    private final Set<Pinned> governed = Sets.newHashSet();
    @Nonnull
    private final Lock accessLock = new ReentrantLock();
    @Nonnull
    private final ResettableOneOffLatch pinnedThreadStartLatch = new ResettableOneOffLatch();
    @Nullable
    private volatile AffinityDescriptor affinity;

    public GovernedAffinityPinnedThreadFactory() {
    }

    public GovernedAffinityPinnedThreadFactory(@Nonnull AffinityDescriptor affinityDescriptor) {
        this.affinity = affinityDescriptor;
    }

    public int governed() {
        this.pinnedThreadStartLatch.await(false);
        AtomicInteger size = new AtomicInteger();
        this.safe(() -> size.set(this.governed.size()));
        return size.get();
    }

    public void alter(@Nonnull AffinityDescriptor affinityDescriptor, boolean affectGoverned) {
        this.affinity = affinityDescriptor;
        if (affectGoverned) {
            this.alter(pinned -> pinned.affinity(affinityDescriptor));
        }
    }

    @Override
    public PinnedThread newThread(@Nonnull Runnable r) {
        this.pinnedThreadStartLatch.await(true);
        PinnedThread pinned = this.pinnedThread(r);
        this.safe(() -> this.governed.add((Pinned)pinned));
        return pinned;
    }

    @Override
    public PinnedThread.ForkJoinWorker newThread(@Nonnull ForkJoinPool pool) {
        this.pinnedThreadStartLatch.await(true);
        PinnedThread.ForkJoinWorker pinned = this.pinnedForkJoinWorkerThread(pool);
        this.safe(() -> this.governed.add((Pinned)pinned));
        return pinned;
    }

    private void safe(@Nonnull Runnable action) {
        this.accessLock.lock();
        try {
            action.run();
        }
        finally {
            this.accessLock.unlock();
        }
    }

    private PinnedThread pinnedThread(@Nonnull Runnable r) {
        if (this.affinity != null) {
            return new GovernedPinnedThread(r, Objects.requireNonNull(this.affinity));
        }
        return new GovernedPinnedThread(r);
    }

    private PinnedThread.ForkJoinWorker pinnedForkJoinWorkerThread(@Nonnull ForkJoinPool pool) {
        if (this.affinity != null) {
            return new GovernedPinnedForkJoinWorkerThread(pool, Objects.requireNonNull(this.affinity));
        }
        return new GovernedPinnedForkJoinWorkerThread(pool);
    }

    private void alter(@Nonnull Consumer<Pinned> fn) {
        this.pinnedThreadStartLatch.await(false);
        this.safe(() -> this.governed.forEach(fn));
    }

    private final class GovernedPinnedForkJoinWorkerThread
    extends PinnedThread.ForkJoinWorker {
        GovernedPinnedForkJoinWorkerThread(@Nonnull ForkJoinPool pool, AffinityDescriptor descriptor) {
            super(pool, descriptor);
        }

        GovernedPinnedForkJoinWorkerThread(ForkJoinPool pool) {
            super(pool);
        }

        protected void onStart() {
            super.onStart();
            GovernedAffinityPinnedThreadFactory.this.pinnedThreadStartLatch.fire();
        }

        protected void onTermination(@Nullable Throwable exception) {
            GovernedAffinityPinnedThreadFactory.this.safe(() -> GovernedAffinityPinnedThreadFactory.this.governed.remove((Object)this));
        }
    }

    private final class GovernedPinnedThread
    extends PinnedThread {
        private GovernedPinnedThread(@Nonnull Runnable target, AffinityDescriptor descriptor) {
            super(target, descriptor);
        }

        private GovernedPinnedThread(Runnable target) {
            super(target);
        }

        public void run() {
            try {
                GovernedAffinityPinnedThreadFactory.this.pinnedThreadStartLatch.fire();
                super.run();
            }
            finally {
                GovernedAffinityPinnedThreadFactory.this.safe(() -> GovernedAffinityPinnedThreadFactory.this.governed.remove((Object)this));
            }
        }
    }
}

