/*
 * Decompiled with CFR 0.152.
 */
package org.sheinbergon.needle.concurrent.util;

import java.util.concurrent.CountDownLatch;
import org.apache.commons.lang3.math.NumberUtils;

public final class ResettableOneOffLatch {
    private volatile CountDownLatch latch;

    public ResettableOneOffLatch() {
        this(false);
    }

    public ResettableOneOffLatch(boolean latched) {
        this.latch = new CountDownLatch(latched ? NumberUtils.INTEGER_ONE : NumberUtils.INTEGER_ZERO);
    }

    public void reset() {
        this.latch = new CountDownLatch(NumberUtils.INTEGER_ONE);
    }

    public void fire() {
        this.latch.countDown();
    }

    public synchronized void await(boolean reset) {
        try {
            this.latch.await();
            if (reset) {
                this.reset();
            }
        }
        catch (InterruptedException iex) {
            throw new RuntimeException(iex);
        }
    }
}

