/*
 * Decompiled with CFR 0.152.
 */
package org.sheinbergon.useragent.analyzer;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.sheinbergon.useragent.analyzer.AsyncUserAgentAnalyzer;
import org.sheinbergon.useragent.analyzer.UserAgentIngredients;
import org.sheinbergon.useragent.analyzer.cache.AsyncCache;
import org.sheinbergon.useragent.analyzer.exception.UserAgentAnalyzerBuildException;
import org.sheinbergon.useragent.analyzer.processor.AsyncProcessor;
import org.sheinbergon.useragent.analyzer.processor.ProcessorTestUtils;
import org.sheinbergon.useragent.analyzer.processor.exception.UserAgentDigestionException;

@RunWith(value=MockitoJUnitRunner.class)
public class AsyncUserAgentAnalyzerTest {
    @Mock
    private AsyncProcessor processor;
    @Mock
    private AsyncCache cache;
    private AsyncUserAgentAnalyzer userAgentAnalyzer;

    @Before
    public void setup() {
        this.userAgentAnalyzer = AsyncUserAgentAnalyzer.builder().processor(this.processor).cache(this.cache).build();
    }

    @Test
    public void cacheHit() throws InterruptedException, ExecutionException {
        this.mockCacheHit();
        ((CompletableFuture)this.userAgentAnalyzer.analyze("Mozilla/5.0 (Linux; Android 7.1.1; ONEPLUS A5000 Build/NMF26X) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Mobile Safari/537.36").thenAccept(ingredients -> Assert.assertEquals((Object)ingredients, (Object)ProcessorTestUtils.VALID_USER_AGENT_INGREDIENTS))).get();
    }

    @Test(expected=UserAgentDigestionException.class)
    public void cacheMissProcessorError() throws Throwable {
        try {
            this.mockCacheMiss();
            this.mockProcessorError();
            this.userAgentAnalyzer.analyze("Mozilla/5.0 (Linux; Android 7.1.1; ONEPLUS A5000 Build/NMF26X) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Mobile Safari/537.36").get();
        }
        catch (ExecutionException x) {
            throw ExceptionUtils.getRootCause((Throwable)x);
        }
    }

    @Test
    public void cacheMissProcessorSuccess() throws InterruptedException, ExecutionException {
        AtomicBoolean cacheWriteFlag = new AtomicBoolean(false);
        this.mockCacheMiss();
        this.mockProcessorSuccess();
        this.mockCacheWrite(cacheWriteFlag);
        ((CompletableFuture)this.userAgentAnalyzer.analyze("Mozilla/5.0 (Linux; Android 7.1.1; ONEPLUS A5000 Build/NMF26X) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Mobile Safari/537.36").thenAccept(ingredients -> {
            Assert.assertEquals((Object)ingredients, (Object)ProcessorTestUtils.VALID_USER_AGENT_INGREDIENTS);
            Assert.assertTrue((boolean)cacheWriteFlag.get());
        })).get();
    }

    @Test(expected=UserAgentAnalyzerBuildException.class)
    public void buildWithoutProcessor() {
        AsyncUserAgentAnalyzer.builder().build();
    }

    @Test
    public void buildWithoutCache() {
        AsyncUserAgentAnalyzer analyzer = AsyncUserAgentAnalyzer.builder().processor(this.processor).build();
        Assert.assertNotNull((Object)analyzer.cache);
    }

    private void mockCacheHit() {
        Mockito.when((Object)this.cache.read("Mozilla/5.0 (Linux; Android 7.1.1; ONEPLUS A5000 Build/NMF26X) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Mobile Safari/537.36")).thenReturn(CompletableFuture.completedFuture(Optional.of(ProcessorTestUtils.VALID_USER_AGENT_INGREDIENTS)));
    }

    private void mockCacheMiss() {
        Mockito.when((Object)this.cache.read("Mozilla/5.0 (Linux; Android 7.1.1; ONEPLUS A5000 Build/NMF26X) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Mobile Safari/537.36")).thenReturn(CompletableFuture.completedFuture(Optional.empty()));
    }

    private void mockProcessorError() {
        Mockito.when((Object)this.processor.process("Mozilla/5.0 (Linux; Android 7.1.1; ONEPLUS A5000 Build/NMF26X) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Mobile Safari/537.36")).thenThrow(new Throwable[]{new UserAgentDigestionException("Mock Error")});
    }

    private void mockProcessorSuccess() {
        Mockito.when((Object)this.processor.process("Mozilla/5.0 (Linux; Android 7.1.1; ONEPLUS A5000 Build/NMF26X) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Mobile Safari/537.36")).thenReturn(CompletableFuture.completedFuture(ProcessorTestUtils.VALID_USER_AGENT_INGREDIENTS));
    }

    private void mockCacheWrite(AtomicBoolean flag) {
        ((AsyncCache)Mockito.doAnswer(invocation -> {
            flag.set(true);
            return null;
        }).when((Object)this.cache)).write(ArgumentMatchers.anyString(), (UserAgentIngredients)ArgumentMatchers.any(UserAgentIngredients.class));
    }
}

