/*
 * Decompiled with CFR 0.152.
 */
package org.sheinbergon.useragent.analyzer;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.sheinbergon.useragent.analyzer.UserAgentAnalyzer;
import org.sheinbergon.useragent.analyzer.UserAgentIngredients;
import org.sheinbergon.useragent.analyzer.cache.Cache;
import org.sheinbergon.useragent.analyzer.cache.PseudoCache;
import org.sheinbergon.useragent.analyzer.exception.UserAgentAnalyzerBuildException;
import org.sheinbergon.useragent.analyzer.processor.Processor;
import org.sheinbergon.useragent.analyzer.processor.ProcessorTestUtils;
import org.sheinbergon.useragent.analyzer.processor.exception.UserAgentDigestionException;

@RunWith(value=MockitoJUnitRunner.class)
public class UserAgentAnalyzerTest {
    @Mock
    private Processor processor;
    @Mock
    private Cache cache;
    private UserAgentAnalyzer userAgentAnalyzer;

    @Before
    public void setup() {
        this.userAgentAnalyzer = UserAgentAnalyzer.builder().processor(this.processor).cache(this.cache).build();
    }

    @Test
    public void cacheHit() {
        this.mockCacheHit();
        UserAgentIngredients ingredients = this.userAgentAnalyzer.analyze("Mozilla/5.0 (Linux; Android 7.1.1; ONEPLUS A5000 Build/NMF26X) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Mobile Safari/537.36");
        Assert.assertEquals((Object)ingredients, (Object)ProcessorTestUtils.VALID_USER_AGENT_INGREDIENTS);
    }

    @Test(expected=UserAgentDigestionException.class)
    public void cacheMissProcessorError() {
        this.mockCacheMiss();
        this.mockProcessorError();
        this.userAgentAnalyzer.analyze("Mozilla/5.0 (Linux; Android 7.1.1; ONEPLUS A5000 Build/NMF26X) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Mobile Safari/537.36");
    }

    @Test
    public void cacheMissProcessorSuccess() {
        AtomicBoolean cacheWriteFlag = new AtomicBoolean(false);
        this.mockCacheMiss();
        this.mockProcessorSuccess();
        this.mockCacheWrite(cacheWriteFlag);
        UserAgentIngredients ingredients = this.userAgentAnalyzer.analyze("Mozilla/5.0 (Linux; Android 7.1.1; ONEPLUS A5000 Build/NMF26X) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Mobile Safari/537.36");
        Assert.assertEquals((Object)ingredients, (Object)ProcessorTestUtils.VALID_USER_AGENT_INGREDIENTS);
        Assert.assertTrue((boolean)cacheWriteFlag.get());
    }

    @Test(expected=UserAgentAnalyzerBuildException.class)
    public void buildWithoutProcessor() {
        UserAgentAnalyzer.builder().build();
    }

    @Test
    public void buildWithoutCache() {
        UserAgentAnalyzer analyzer = UserAgentAnalyzer.builder().processor(this.processor).build();
        Assert.assertTrue((boolean)(analyzer.cache instanceof PseudoCache));
    }

    private void mockCacheHit() {
        Mockito.when((Object)this.cache.read("Mozilla/5.0 (Linux; Android 7.1.1; ONEPLUS A5000 Build/NMF26X) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Mobile Safari/537.36")).thenReturn(Optional.of(ProcessorTestUtils.VALID_USER_AGENT_INGREDIENTS));
    }

    private void mockCacheMiss() {
        Mockito.when((Object)this.cache.read("Mozilla/5.0 (Linux; Android 7.1.1; ONEPLUS A5000 Build/NMF26X) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Mobile Safari/537.36")).thenReturn(Optional.empty());
    }

    private void mockProcessorError() {
        Mockito.when((Object)this.processor.process("Mozilla/5.0 (Linux; Android 7.1.1; ONEPLUS A5000 Build/NMF26X) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Mobile Safari/537.36")).thenThrow(new Throwable[]{new UserAgentDigestionException("Mock Error")});
    }

    private void mockProcessorSuccess() {
        Mockito.when((Object)this.processor.process("Mozilla/5.0 (Linux; Android 7.1.1; ONEPLUS A5000 Build/NMF26X) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Mobile Safari/537.36")).thenReturn((Object)ProcessorTestUtils.VALID_USER_AGENT_INGREDIENTS);
    }

    private void mockCacheWrite(AtomicBoolean flag) {
        ((Cache)Mockito.doAnswer(invocation -> {
            flag.set(true);
            return null;
        }).when((Object)this.cache)).write(ArgumentMatchers.anyString(), (UserAgentIngredients)ArgumentMatchers.any(UserAgentIngredients.class));
    }
}

