/*
 * Decompiled with CFR 0.152.
 */
package org.sheinbergon.useragent.analyzer.cache;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.sheinbergon.useragent.analyzer.cache.AsyncCache;
import org.sheinbergon.useragent.analyzer.cache.Cache;
import org.sheinbergon.useragent.analyzer.cache.CacheTestUtils;

@RunWith(value=MockitoJUnitRunner.class)
public class AsyncCacheWrappingTest {
    @Mock
    private Cache cache;
    private AsyncCache asyncCache;

    @Before
    public void setup() {
        this.asyncCache = AsyncCache.Builder.wrap((Cache)this.cache);
    }

    @Test
    public void asyncCacheWrapping() throws InterruptedException, ExecutionException, TimeoutException {
        this.mockCacheReadAccess();
        ((CompletableFuture)this.asyncCache.read("key-1").thenAccept(optional -> {
            Assert.assertTrue((boolean)optional.isPresent());
            Assert.assertEquals(optional.get(), (Object)CacheTestUtils.TEST_INGREDIENTS_1);
        })).get();
    }

    private void mockCacheReadAccess() {
        Mockito.when((Object)this.cache.read(ArgumentMatchers.anyString())).thenReturn(Optional.of(CacheTestUtils.TEST_INGREDIENTS_1));
    }
}

