/*
 * Decompiled with CFR 0.152.
 */
package org.sheinbergon.useragent.analyzer.processor;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.sheinbergon.useragent.analyzer.processor.AsyncProcessor;
import org.sheinbergon.useragent.analyzer.processor.ProcessorTestUtils;
import org.sheinbergon.useragent.analyzer.processor.exception.UserAgentIngestionException;

@RunWith(value=MockitoJUnitRunner.class)
public class AsyncProcessorTest {
    @Mock
    private AsyncProcessor<Object> processor;

    @Test(expected=UserAgentIngestionException.class)
    public void emptyIngestionProcessing() throws Throwable {
        try {
            this.mockEmptyIngetsion();
            this.mockExternalAccess();
            this.processor.process(ProcessorTestUtils.randomString()).get();
        }
        catch (ExecutionException x) {
            throw ExceptionUtils.getRootCause((Throwable)x);
        }
    }

    @Test
    public void successfulProcessing() throws ExecutionException, TimeoutException, InterruptedException {
        this.mockAnyIngetsion();
        this.mockSuccesfulDigetsion();
        this.mockExternalAccess();
        ((CompletableFuture)this.processor.process("Mozilla/5.0 (Linux; Android 7.1.1; ONEPLUS A5000 Build/NMF26X) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Mobile Safari/537.36").thenAccept(ingredients -> Assert.assertEquals((Object)ingredients, (Object)ProcessorTestUtils.VALID_USER_AGENT_INGREDIENTS))).get();
    }

    private void mockExternalAccess() {
        Mockito.when((Object)this.processor.process(ArgumentMatchers.anyString())).thenCallRealMethod();
    }

    private void mockEmptyIngetsion() {
        Mockito.when((Object)this.processor.ingest(ArgumentMatchers.anyString())).thenReturn(CompletableFuture.supplyAsync(Optional::empty));
    }

    private void mockAnyIngetsion() {
        Mockito.when((Object)this.processor.ingest(ArgumentMatchers.anyString())).thenReturn(CompletableFuture.completedFuture(Optional.of(new Object())));
    }

    private void mockSuccesfulDigetsion() {
        Mockito.when((Object)this.processor.digest(ArgumentMatchers.any())).thenReturn((Object)ProcessorTestUtils.VALID_USER_AGENT_INGREDIENTS);
    }
}

