/*
 * Decompiled with CFR 0.152.
 */
package org.shept.beans.support;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.support.MutableSortDefinition;
import org.springframework.beans.support.SortDefinition;
import org.springframework.util.StringUtils;

public class PropertyComparator
implements Comparator {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final SortDefinition sortDefinition;
    private final BeanWrapperImpl beanWrapper = new BeanWrapperImpl(false);

    public PropertyComparator(SortDefinition sortDefinition) {
        this.sortDefinition = sortDefinition;
    }

    public PropertyComparator(String property, boolean ignoreCase, boolean ascending) {
        this.sortDefinition = new MutableSortDefinition(property, ignoreCase, ascending);
    }

    public final SortDefinition getSortDefinition() {
        return this.sortDefinition;
    }

    public int compare(Object o1, Object o2) {
        int result;
        Object v1 = this.getPropertyValue(o1);
        Object v2 = this.getPropertyValue(o2);
        if (this.sortDefinition.isIgnoreCase() && v1 instanceof String && v2 instanceof String) {
            v1 = ((String)v1).toLowerCase();
            v2 = ((String)v2).toLowerCase();
        }
        try {
            result = v1 != null ? (v2 != null ? ((Comparable)v1).compareTo(v2) : -1) : (v2 != null ? 1 : 0);
        }
        catch (RuntimeException ex) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("Could not sort objects [" + o1 + "] and [" + o2 + "]"), (Throwable)ex);
            }
            return 0;
        }
        return this.sortDefinition.isAscending() ? result : -result;
    }

    private Object getPropertyValue(Object obj) {
        try {
            String propertyName = this.sortDefinition.getProperty();
            if (obj.getClass().isArray() || obj instanceof Map || obj instanceof List || obj instanceof Set) {
                WrappedProperty o = new WrappedProperty();
                o.setProperty(obj);
                propertyName = "property" + propertyName;
                this.beanWrapper.setWrappedInstance((Object)o);
            } else {
                this.beanWrapper.setWrappedInstance(obj);
            }
            return this.beanWrapper.getPropertyValue(propertyName);
        }
        catch (BeansException ex) {
            this.logger.info((Object)"PropertyComparator could not access property - treating as null for sorting", (Throwable)ex);
            return null;
        }
    }

    public static void sort(List source, SortDefinition sortDefinition) throws BeansException {
        if (StringUtils.hasText((String)sortDefinition.getProperty())) {
            Collections.sort(source, new PropertyComparator(sortDefinition));
        }
    }

    public static void sort(Object[] source, SortDefinition sortDefinition) throws BeansException {
        if (StringUtils.hasText((String)sortDefinition.getProperty())) {
            Arrays.sort(source, new PropertyComparator(sortDefinition));
        }
    }

    private static class WrappedProperty {
        public Object property;

        private WrappedProperty() {
        }

        public Object getProperty() {
            return this.property;
        }

        public void setProperty(Object property) {
            this.property = property;
        }
    }
}

