/*
 * Decompiled with CFR 0.152.
 */
package org.shept.org.springframework.beans;

import java.beans.PropertyEditorSupport;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import org.springframework.util.StringUtils;

public class CustomCalendarEditor
extends PropertyEditorSupport {
    private DateFormat dateFormat;
    private boolean allowEmpty;

    public CustomCalendarEditor(DateFormat dateFormat, boolean allowEmpty) {
        this.dateFormat = dateFormat;
        this.allowEmpty = allowEmpty;
    }

    @Override
    public String getAsText() {
        Calendar value = (Calendar)this.getValue();
        return null != value ? this.dateFormat.format(value.getTime()) : "";
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (this.allowEmpty && !StringUtils.hasText((String)text)) {
            this.setValue(null);
        } else {
            try {
                Calendar cal = Calendar.getInstance();
                cal.setTime(this.dateFormat.parse(text));
                this.setValue(cal);
            }
            catch (ParseException ex) {
                throw new IllegalArgumentException();
            }
        }
    }
}

