/*
 * Decompiled with CFR 0.152.
 */
package org.shept.org.springframework.beans.support;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.shept.org.springframework.beans.support.ModelSupplier;
import org.shept.org.springframework.beans.support.MultiChoice;
import org.shept.org.springframework.beans.support.PagedListHolder;

public class ChoiceListHolder<E>
extends PagedListHolder<E>
implements Serializable,
MultiChoice<E> {
    public static final String OPTIONS_BINDING_NAME = "options";
    private static final long serialVersionUID = 1L;
    protected List<Boolean> options = new ArrayList<Boolean>(0);
    protected Object selectedAction;

    protected void initOptions(int startIndex, int endIndex) {
        if (startIndex == 0) {
            this.options = new ArrayList<Boolean>(0);
        }
        for (int i = startIndex; i < endIndex; ++i) {
            this.options.add(Boolean.FALSE);
        }
    }

    public List<Boolean> getOptions() {
        return this.options;
    }

    @Override
    public List<E> getSelectedItems() {
        ArrayList sel = new ArrayList(0);
        List src = this.getSource();
        for (int i = 0; i < src.size(); ++i) {
            if (!this.options.get(i).booleanValue()) continue;
            sel.add(src.get(i));
        }
        return sel;
    }

    public List<ModelWithSelection> getPageListWithSelection() {
        ArrayList<ModelWithSelection> itemList = new ArrayList<ModelWithSelection>(this.getPageCount());
        List src = this.getSource();
        List<Boolean> opt = this.getOptions();
        for (int i = this.getFirstElementOnPage(); i < this.getLastElementOnPage() + 1; ++i) {
            itemList.add(new ModelWithSelection(opt.get(i), src.get(i)));
        }
        return itemList;
    }

    public List<Boolean> getPageOptions() {
        return this.getOptions().subList(this.getFirstElementOnPage(), this.getLastElementOnPage() + 1);
    }

    public Object getSelectedAction() {
        return this.selectedAction;
    }

    public void setSelectedAction(Object selectedAction) {
        this.selectedAction = selectedAction;
    }

    public class ModelWithSelection
    implements ModelSupplier {
        private Boolean selected;
        private Object model;

        public ModelWithSelection(Boolean selected, Object model) {
            this.selected = selected;
            this.model = model;
        }

        public Boolean getSelected() {
            return this.selected;
        }

        public void setSelected(Boolean selected) {
            this.selected = selected;
        }

        @Override
        public Object getModel() {
            return this.model;
        }

        public void setModel(Object model) {
            this.model = model;
        }
    }
}

