/*
 * Decompiled with CFR 0.152.
 */
package org.shept.org.springframework.beans.support;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.shept.beans.support.FilterDefinition;
import org.shept.org.springframework.beans.support.ChoiceListHolder;
import org.shept.org.springframework.beans.support.FilterType;
import org.shept.org.springframework.beans.support.Refreshable;
import org.shept.org.springframework.web.servlet.mvc.support.ModelUtils;
import org.shept.persistence.ModelCreation;
import org.shept.persistence.provider.ScrollingListProvider;
import org.shept.persistence.provider.ScrollingListProviderFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.support.SortDefinition;
import org.springframework.dao.support.DaoSupport;

public class FilteredListHolder<E>
extends ChoiceListHolder<E>
implements Refreshable,
Serializable {
    private static final long serialVersionUID = 1L;
    protected transient DaoSupport dao;
    protected transient ScrollingListProviderFactory listFactory;
    protected transient ScrollingListProvider sourceProvider;
    protected FilterDefinition filter;
    protected FilterDefinition filterUsed;
    protected FilterDefinition filterInitial;
    protected Boolean sortInMemory = true;
    protected Boolean reloadOnSort = true;
    protected boolean alwaysRefresh = true;

    public FilteredListHolder() {
    }

    public FilteredListHolder(ScrollingListProvider sourceProvider) {
        this.sourceProvider = sourceProvider;
    }

    protected void loadListFirst() {
        this.initNewModelTemplate();
        ScrollingListProvider sp = this.getSourceProvider();
        sp.setSortDefinition(this.getSort());
        sp.setFilterDefinition(this.getFilter());
        this.setSource(sp.loadListFirst());
        this.initOptions(0, this.getSource().size());
        if (this.getSortInMemory().booleanValue()) {
            this.removeNullObjects();
            super.doSort(this.getSource(), this.getSort());
        }
        this.sortUsed = this.copySortDefinition(this.getSort());
    }

    protected void initNewModelTemplate() {
        ModelCreation newTemplate = this.getFilter().getNewModelTemplate();
        this.setNewModelTemplate(newTemplate);
    }

    protected void loadListNext() {
        if (this.getSource().size() > 0) {
            int startIndex = this.getSource().size();
            this.getSource().addAll(this.getSourceProvider().loadListNext());
            this.initOptions(startIndex, this.getSource().size());
        }
    }

    @Override
    protected void doSort(List<E> source, SortDefinition sort) {
        if (this.getReloadOnSort().booleanValue()) {
            this.loadListFirst();
        } else if (this.getSortInMemory().booleanValue()) {
            this.removeNullObjects();
            super.doSort(source, sort);
        }
    }

    @Override
    protected Object copyModel(Object model) {
        return ModelUtils.copyModel(this.dao, model);
    }

    @Override
    public FilterDefinition getFilter() {
        return this.filter;
    }

    @Override
    public ScrollingListProvider getSourceProvider() {
        return this.sourceProvider;
    }

    @Override
    public boolean isEol() {
        if (this.getSourceProvider() == null) {
            return true;
        }
        return this.getSourceProvider().isEol();
    }

    public void clear() {
        if (this.getSource() != null) {
            this.getSource().clear();
        }
    }

    @Override
    public void refresh() {
        if (this.alwaysRefresh || this.filter != null && !this.filter.equals(this.filterUsed)) {
            this.initSourceProvider(this.dao);
            this.loadListFirst();
            if (this.filter != null && !this.filter.equals(this.filterUsed)) {
                this.setPage(0);
            }
            if (null != this.filter) {
                this.filterUsed = (FilterDefinition)BeanUtils.instantiateClass(this.filter.getClass());
                BeanUtils.copyProperties((Object)this.filter, (Object)this.filterUsed);
            }
        }
    }

    @Override
    @Deprecated
    public void refresh(DaoSupport dao) {
        this.dao = dao;
        this.refresh();
    }

    protected void removeNullObjects() {
        ArrayList<Object> al = new ArrayList<Object>();
        al.add(null);
        this.getSource().removeAll(al);
    }

    @Override
    public void setFilter(FilterDefinition filter) {
        this.filter = filter;
        if (filter != null && this.filterInitial == null) {
            this.setFilterInitial(this.filter);
        }
    }

    @Override
    public void setPage(int page) {
        if (page >= this.getPageCount() - 1) {
            this.loadListNext();
        }
        super.setPage(page);
    }

    @Override
    public void setPageSize(int pageSize) {
        int newLoadSize = pageSize * 3;
        int newPage = this.getFirstElementOnPage() / pageSize;
        super.setPageSize(pageSize);
        super.setPage(newPage);
        if (this.getSourceProvider() != null && newLoadSize != this.getSourceProvider().getLoadSize()) {
            this.getSourceProvider().setLoadSize(newLoadSize);
            if (this.getLastElementOnPage() >= this.getSource().size() - 1) {
                this.loadListNext();
            }
        }
    }

    @Override
    public void setSource(List<E> source) {
        super.setSource(source);
    }

    public void setSourceProvider(ScrollingListProvider sourceProvider) {
        this.sourceProvider = sourceProvider;
    }

    public FilterDefinition getFilterUsed() {
        return this.filterUsed;
    }

    public void setFilterUsed(FilterDefinition filterUsed) {
        this.filterUsed = filterUsed;
    }

    public Boolean getSortInMemory() {
        return this.sortInMemory;
    }

    public void setSortInMemory(Boolean sortInMemory) {
        this.sortInMemory = sortInMemory;
    }

    public Boolean getReloadOnSort() {
        return this.reloadOnSort;
    }

    public void setReloadOnSort(Boolean reloadOnSort) {
        this.reloadOnSort = reloadOnSort;
    }

    public ScrollingListProviderFactory getListFactory(DaoSupport dao) {
        if (this.listFactory == null) {
            this.listFactory = new ScrollingListProviderFactory();
            this.listFactory.setDao(dao);
        }
        return this.listFactory;
    }

    public void setListFactory(ScrollingListProviderFactory listFactory) {
        this.listFactory = listFactory;
    }

    protected void initSourceProvider(DaoSupport dao) {
        if (null == this.getFilter()) {
            throw new IllegalStateException("The filter provider is not yet initialized");
        }
        ScrollingListProvider sp = this.getListFactory(dao).getScrollingList(this.getFilter());
        if (this.getSourceProvider() == null || !this.getSourceProvider().getClass().equals(sp.getClass())) {
            sp.setLoadSize(this.getDefaultLoadSize());
            if (sp.getDao() == null && dao != null) {
                sp.setDao(dao);
            }
            this.setSourceProvider(sp);
        }
    }

    public int getDefaultLoadSize() {
        return this.getPageSize() * 2 + 1;
    }

    public FilterDefinition getFilterInitial() {
        return this.filterInitial;
    }

    public void setFilterInitial(FilterDefinition filterInitial) {
        this.filterInitial = this.copyFilterDefinition(filterInitial);
    }

    protected FilterDefinition copyFilterDefinition(FilterDefinition f) {
        FilterDefinition fd = (FilterDefinition)BeanUtils.instantiateClass(f.getClass());
        BeanUtils.copyProperties((Object)f, (Object)fd);
        return fd;
    }

    @Override
    public void setUseFilter(FilterType type) {
        switch (type) {
            case FILTER_INITIAL: {
                if (this.getFilterInitial() == null) {
                    throw new IllegalStateException("The filterInitial is not yet initialized");
                }
                this.setFilter(this.copyFilterDefinition(this.getFilterInitial()));
                break;
            }
            case FILTER_LAST_USED: {
                if (this.getFilterUsed() == null) {
                    throw new IllegalStateException("The filterUsed is not yet initialized");
                }
                this.setFilter(this.getFilterUsed());
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        if (this.filter != null) {
            sb.append(" Filter: " + this.filter.toString());
        }
        if (this.filterInitial != null) {
            sb.append(" FilterInitial: " + this.filterInitial.toString());
        }
        if (this.filterUsed != null) {
            sb.append(" FilterUsed: " + this.filterUsed.toString());
        }
        sb.append(" reloadOnSort: " + this.reloadOnSort);
        sb.append(" sortInMemory: " + this.sortInMemory);
        return sb.toString();
    }

    public boolean isAlwaysRefresh() {
        return this.alwaysRefresh;
    }

    public void setAlwaysRefresh(boolean alwaysRefresh) {
        this.alwaysRefresh = alwaysRefresh;
    }

    @Override
    public void setDao(DaoSupport dao) {
        this.dao = dao;
    }
}

