/*
 * Decompiled with CFR 0.152.
 */
package org.shept.org.springframework.beans.support;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.shept.beans.support.PropertyComparator;
import org.shept.org.springframework.beans.support.PageableList;
import org.shept.org.springframework.web.servlet.mvc.support.ModelUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.support.MutableSortDefinition;
import org.springframework.beans.support.SortDefinition;
import org.springframework.util.CollectionUtils;

public class PagedListHolder<E>
implements Serializable,
PageableList<E> {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_MAX_LINKED_PAGES = 10;
    private List<E> source;
    protected transient Date refreshDate;
    protected SortDefinition sort = new MutableSortDefinition();
    protected SortDefinition sortUsed;
    protected int pageSize = 10;
    protected int page = 0;
    protected transient boolean newPageSet;
    protected int maxLinkedPages = 10;
    protected Object newModelTemplate;
    protected int newModelSize = 1;

    public PagedListHolder() {
        this(new ArrayList(0));
    }

    public PagedListHolder(List<E> source) {
        this.setSource(source);
        this.setSort((SortDefinition)new MutableSortDefinition(true));
    }

    public PagedListHolder(List<E> source, SortDefinition sort, Object newModelTemplate) {
        this.setNewModelTemplate(newModelTemplate);
        this.setSource(source);
        this.setSort(sort);
    }

    protected SortDefinition copySortDefinition(SortDefinition s) {
        SortDefinition sd = (SortDefinition)BeanUtils.instantiateClass(s.getClass());
        BeanUtils.copyProperties((Object)s, (Object)sd);
        return sd;
    }

    protected void doSort(List<E> src, SortDefinition s) {
        PropertyComparator.sort(src, s);
    }

    protected int getFirstElementOnPage_orig() {
        return this.getPageSize() * this.getPage();
    }

    @Override
    public int getFirstElementOnPage() {
        int firstElement = this.getFirstElementOnPage_orig();
        if (firstElement < 0) {
            return Integer.MAX_VALUE;
        }
        return firstElement;
    }

    @Override
    public int getFirstLinkedPage() {
        return Math.max(0, this.getPage() - this.getMaxLinkedPages() / 2);
    }

    protected int getLastElementOnPage_orig() {
        int endIndex = this.getPageSize() * (this.getPage() + 1);
        return (endIndex > this.getSource().size() ? this.getSource().size() : endIndex) - 1;
    }

    @Override
    public int getLastElementOnPage() {
        int endIndex = this.getLastElementOnPage_orig();
        if (endIndex < 0) {
            return 0;
        }
        return endIndex;
    }

    @Override
    public int getLastLinkedPage() {
        return Math.min(this.getFirstLinkedPage() + this.getMaxLinkedPages() - 1, this.getPageCount() - 1);
    }

    @Override
    public int getMaxLinkedPages() {
        return this.maxLinkedPages;
    }

    @Override
    public int getNrOfElements() {
        return this.getSource().size();
    }

    @Override
    public int getPage() {
        this.newPageSet = false;
        if (this.page >= this.getPageCount()) {
            this.page = this.getPageCount() - 1;
        }
        return this.page;
    }

    @Override
    public int getPageCount() {
        float nrOfPages = (float)this.getSource().size() / (float)this.getPageSize();
        return (int)(nrOfPages > (float)((int)nrOfPages) || (double)nrOfPages == 0.0 ? nrOfPages + 1.0f : nrOfPages);
    }

    @Override
    public List<E> getPageList() {
        return this.getSource().subList(this.getFirstElementOnPage(), this.getLastElementOnPage() + 1);
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public Date getRefreshDate() {
        return this.refreshDate;
    }

    @Override
    public SortDefinition getSort() {
        return this.sort;
    }

    @Override
    public SortDefinition getSortUsed() {
        return this.sortUsed;
    }

    @Override
    public List<E> getSource() {
        return this.source;
    }

    @Override
    public boolean isFirstPage() {
        return this.getPage() == 0;
    }

    @Override
    public boolean isLastPage() {
        return this.getPage() == this.getPageCount() - 1;
    }

    @Override
    public boolean isVisible(Integer idx) {
        return idx >= this.getFirstElementOnPage() && idx <= this.getLastElementOnPage();
    }

    @Override
    public void nextPage() {
        if (!this.isLastPage()) {
            ++this.page;
        }
    }

    @Override
    public boolean isSortNeeded() {
        SortDefinition s = this.getSort();
        return s != null && !s.equals(this.getSortUsed());
    }

    @Override
    public void previousPage() {
        if (!this.isFirstPage()) {
            --this.page;
        }
    }

    @Override
    public void resort() {
        SortDefinition s = this.getSort();
        if (s != null && !s.equals(this.sortUsed)) {
            this.sortUsed = this.copySortDefinition(s);
            this.doSort(this.getSource(), s);
            this.setPage(0);
        }
    }

    public void setMaxLinkedPages(int maxLinkedPages) {
        this.maxLinkedPages = maxLinkedPages;
    }

    @Override
    public void setPage(int page) {
        this.page = page;
        this.newPageSet = true;
    }

    @Override
    public void setPageSize(int pageSize) {
        if (pageSize != this.pageSize) {
            this.pageSize = pageSize;
            if (!this.newPageSet) {
                this.page = 0;
            }
        }
    }

    @Override
    public void setSort(SortDefinition sort) {
        this.sort = sort;
    }

    @Override
    public void setSource(List<E> source) {
        List<E> newModels = this.getNewModels();
        if (newModels.size() > 0) {
            source.addAll(0, newModels);
        }
        this.setSourceInternal(source);
    }

    protected void setSourceInternal(List<E> source) {
        this.source = source;
        this.refreshDate = new Date();
        this.sortUsed = null;
    }

    protected List<E> getNewModels() {
        ArrayList<Object> newModels = new ArrayList<Object>(this.getNewModelSize());
        Object template = this.getNewModelTemplate();
        if (template != null) {
            for (int i = 0; i < this.getNewModelSize(); ++i) {
                Object newModel = this.copyModel(template);
                newModels.add(newModel);
            }
        }
        return newModels;
    }

    protected Object copyModel(Object model) {
        return ModelUtils.copyModel(model);
    }

    @Override
    public Object getNewModelTemplate() {
        return this.newModelTemplate;
    }

    @Override
    public void setNewModelTemplate(Object newModelTemplate) {
        this.newModelTemplate = this.copyModel(newModelTemplate);
    }

    @Override
    public int getNewModelSize() {
        return this.newModelSize;
    }

    @Override
    public void setNewModelSize(int newModelSize) {
        this.newModelSize = newModelSize;
    }

    @Override
    public boolean isEol() {
        return true;
    }

    @Override
    public String getListBindingName() {
        return "source";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().toString() + " on ");
        if (CollectionUtils.isEmpty(this.source)) {
            sb.append(" empty source");
        } else {
            sb.append(" on " + this.source.size() + " objects in list with hash " + String.valueOf(((Object)this.source).hashCode()));
        }
        sb.append(" -- ");
        sb.append("Sort: ");
        if (this.sort != null) {
            sb.append("Property: " + this.sort.getProperty());
            sb.append(" ascending " + this.sort.isAscending());
            sb.append(" ignoreCase: " + this.sort.isIgnoreCase());
        } else {
            sb.append(" null");
        }
        sb.append("SortUsed: ");
        if (this.sortUsed != null) {
            sb.append("Property: " + this.sortUsed.getProperty());
            sb.append(" ascending " + this.sortUsed.isAscending());
            sb.append(" ignoreCase: " + this.sortUsed.isIgnoreCase());
        } else {
            sb.append(" null");
        }
        sb.append(" maxLinkedPages: " + this.maxLinkedPages);
        sb.append(" newPageSet: " + this.newPageSet);
        sb.append(" page: " + this.page);
        sb.append(" pageSize: " + this.pageSize);
        sb.append(" refreshDate: " + this.refreshDate);
        return sb.toString();
    }
}

