/*
 * Decompiled with CFR 0.152.
 */
package org.shept.org.springframework.orm.hibernate3;

import java.util.Collection;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.shept.beans.support.QueryDefinition;
import org.shept.org.springframework.orm.hibernate3.CriteriaBuilder;
import org.shept.org.springframework.orm.hibernate3.IgnoreCaseCriteriaBuilder;
import org.springframework.beans.support.SortDefinition;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class HibernateTemplateExtended
extends HibernateTemplate {
    private CriteriaBuilder criteriaBuilder = new IgnoreCaseCriteriaBuilder();

    public HibernateTemplateExtended() {
    }

    public HibernateTemplateExtended(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public HibernateTemplateExtended(SessionFactory sessionFactory, boolean allowCreate) {
        super(sessionFactory, allowCreate);
    }

    public boolean isDirty() {
        Boolean executeWithNativeSession = (Boolean)this.executeWithNativeSession((HibernateCallback)new HibernateCallback<Boolean>(){

            public Boolean doInHibernate(Session session) throws HibernateException {
                return session.isDirty();
            }
        });
        return executeWithNativeSession;
    }

    public Object findObjectByNamedParam(String queryString, String paramName, Object value) throws DataAccessException {
        return this.findObjectByNamedParam(queryString, new String[]{paramName}, new Object[]{value});
    }

    public Object findObjectByNamedParam(final String queryString, final String[] paramNames, final Object[] values) throws DataAccessException {
        if (paramNames.length != values.length) {
            throw new IllegalArgumentException("Length of paramNames array must match length of values array");
        }
        List res = (List)this.executeWithNativeSession((HibernateCallback)new HibernateCallback<List>(){

            public List doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.createQuery(queryString);
                HibernateTemplateExtended.this.prepareQuery(queryObject);
                queryObject.setMaxResults(1);
                queryObject.setFetchSize(1);
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        HibernateTemplateExtended.this.applyNamedParameterToQuery(queryObject, paramNames[i], values[i]);
                    }
                }
                return queryObject.list();
            }
        });
        if (CollectionUtils.isEmpty((Collection)res)) {
            return null;
        }
        return res.get(0);
    }

    public Object findObjectByNamedQuery(String queryName) throws DataAccessException {
        return this.findObjectByNamedQuery(queryName, null);
    }

    public Object findObjectByNamedQuery(String queryName, Object value) throws DataAccessException {
        return this.findObjectByNamedQuery(queryName, new Object[]{value});
    }

    public Object findObjectByNamedQuery(final String queryName, final Object[] values) throws DataAccessException {
        List res = (List)this.executeWithNativeSession((HibernateCallback)new HibernateCallback<List>(){

            public List doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.getNamedQuery(queryName);
                HibernateTemplateExtended.this.prepareQuery(queryObject);
                queryObject.setMaxResults(1);
                queryObject.setFetchSize(1);
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        queryObject.setParameter(i, values[i]);
                    }
                }
                return queryObject.list();
            }
        });
        if (CollectionUtils.isEmpty((Collection)res)) {
            return null;
        }
        return res.get(0);
    }

    public Object findObjectByNamedQueryAndNamedParam(String queryName, String paramName, Object value) throws DataAccessException {
        return this.findObjectByNamedQueryAndNamedParam(queryName, new String[]{paramName}, new Object[]{value});
    }

    public Object findObjectByNamedQueryAndNamedParam(final String queryName, final String[] paramNames, final Object[] values) throws DataAccessException {
        if (paramNames != null && values != null && paramNames.length != values.length) {
            throw new IllegalArgumentException("Length of paramNames array must match length of values array");
        }
        List res = (List)this.executeWithNativeSession((HibernateCallback)new HibernateCallback<List>(){

            public List doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.getNamedQuery(queryName);
                HibernateTemplateExtended.this.prepareQuery(queryObject);
                queryObject.setMaxResults(1);
                queryObject.setFetchSize(1);
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        HibernateTemplateExtended.this.applyNamedParameterToQuery(queryObject, paramNames[i], values[i]);
                    }
                }
                return queryObject.list();
            }
        });
        if (CollectionUtils.isEmpty((Collection)res)) {
            return null;
        }
        return res.get(0);
    }

    public List<?> find(final QueryDefinition queryDef, final int firstResult, final int maxResults) {
        return (List)this.executeWithNativeSession(new HibernateCallback<List<?>>(){

            public List<?> doInHibernate(Session session) throws HibernateException {
                Query queryObject;
                block6: {
                    block5: {
                        queryObject = HibernateTemplateExtended.this.isNamedQuery(queryDef.getQuery()) ? session.getNamedQuery(queryDef.getQuery()) : session.createQuery(queryDef.getQuery());
                        HibernateTemplateExtended.this.prepareQuery(queryObject);
                        if (firstResult >= 0) {
                            queryObject.setFirstResult(firstResult);
                        }
                        if (maxResults > 0) {
                            queryObject.setFetchSize(maxResults);
                            queryObject.setMaxResults(maxResults);
                        }
                        if (!ObjectUtils.isEmpty((Object[])queryDef.getParamNames())) break block5;
                        if (queryDef.getValues() == null) break block6;
                        for (int i = 0; i < queryDef.getValues().length; ++i) {
                            queryObject.setParameter(i, queryDef.getValues()[i]);
                        }
                        break block6;
                    }
                    if (queryDef.getValues() != null) {
                        for (int i = 0; i < queryDef.getValues().length; ++i) {
                            HibernateTemplateExtended.this.applyNamedParameterToQuery(queryObject, queryDef.getParamNames()[i], queryDef.getValues()[i]);
                        }
                    }
                }
                return queryObject.list();
            }
        });
    }

    public List findByExample(Object exampleEntity, SortDefinition sort) throws DataAccessException {
        return this.findByExample(null, exampleEntity, sort, -1, -1);
    }

    public List findByExample(String entityName, Object exampleEntity, SortDefinition sort) throws DataAccessException {
        return this.findByExample(entityName, exampleEntity, sort, -1, -1);
    }

    public List findByExample(Object exampleEntity, SortDefinition sort, int firstResult, int maxResults) throws DataAccessException {
        return this.findByExample(null, exampleEntity, sort, firstResult, maxResults);
    }

    public List findByExample(final String entityName, final Object exampleEntity, final SortDefinition sort, final int firstResult, final int maxResults) throws DataAccessException {
        Assert.notNull((Object)exampleEntity, (String)"Example entity must not be null");
        return (List)this.executeWithNativeSession((HibernateCallback)new HibernateCallback<List>(){

            public List doInHibernate(Session session) throws HibernateException {
                Criteria executableCriteria = HibernateTemplateExtended.this.criteriaBuilder.buildCriteria(entityName, exampleEntity, sort, session);
                HibernateTemplateExtended.this.prepareCriteria(executableCriteria);
                if (firstResult >= 0) {
                    executableCriteria.setFirstResult(firstResult);
                }
                if (maxResults > 0) {
                    executableCriteria.setMaxResults(maxResults);
                }
                return executableCriteria.list();
            }
        });
    }

    public Object findObjectByExample(Object exampleEntity) throws DataAccessException {
        List res = this.findByExample(exampleEntity);
        if (CollectionUtils.isEmpty((Collection)res)) {
            return null;
        }
        return res.get(0);
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return this.criteriaBuilder;
    }

    public void setCriteriaBuilder(CriteriaBuilder criteriaBuilder) {
        this.criteriaBuilder = criteriaBuilder;
    }

    private boolean isNamedQuery(String query) {
        if (!StringUtils.hasText((String)query)) {
            return false;
        }
        String[] check = new String[]{"select ", "from "};
        String q = StringUtils.trimLeadingWhitespace((String)query);
        for (int i = 0; i < check.length; ++i) {
            if (!q.regionMatches(true, 0, check[i], 0, check[i].length())) continue;
            return false;
        }
        return true;
    }
}

