/*
 * Decompiled with CFR 0.152.
 */
package org.shept.org.springframework.orm.hibernate3;

import org.hibernate.Criteria;
import org.hibernate.EntityMode;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.Order;
import org.hibernate.metadata.ClassMetadata;
import org.shept.org.springframework.orm.hibernate3.CriteriaBuilder;
import org.springframework.beans.support.SortDefinition;
import org.springframework.util.StringUtils;

public class IgnoreCaseCriteriaBuilder
implements CriteriaBuilder {
    @Override
    public Criteria buildCriteria(String entityName, Object exampleEntity, SortDefinition sortDef, Session session) {
        String[] propNames;
        Criteria executableCriteria = entityName != null ? session.createCriteria(entityName) : session.createCriteria(exampleEntity.getClass());
        executableCriteria.add((Criterion)Example.create((Object)exampleEntity).ignoreCase());
        String sortPropRoot = "";
        if (sortDef != null & StringUtils.hasText((String)sortDef.getProperty())) {
            int rootIdx = sortDef.getProperty().indexOf(".");
            if (rootIdx > 0) {
                sortPropRoot = sortDef.getProperty().substring(0, rootIdx);
                executableCriteria.createAlias(sortPropRoot, sortPropRoot);
            }
            executableCriteria.addOrder(sortDef.isAscending() ? Order.asc((String)sortDef.getProperty()) : Order.desc((String)sortDef.getProperty()));
        }
        ClassMetadata meta = session.getSessionFactory().getClassMetadata(exampleEntity.getClass());
        for (String propName : propNames = meta.getPropertyNames()) {
            Object propVal;
            if (!meta.getPropertyType(propName).isEntityType() || (propVal = meta.getPropertyValue(exampleEntity, propName, EntityMode.POJO)) == null || propName.equals(sortPropRoot)) continue;
            executableCriteria.createCriteria(propName).add((Criterion)Example.create((Object)propVal).ignoreCase());
        }
        return executableCriteria;
    }
}

