/*
 * Decompiled with CFR 0.152.
 */
package org.shept.org.springframework.web.bind.support;

import java.util.LinkedHashMap;
import java.util.Map;
import org.shept.org.springframework.web.servlet.mvc.delegation.ComponentToken;
import org.shept.org.springframework.web.servlet.mvc.delegation.ComponentUtils;
import org.shept.org.springframework.web.servlet.mvc.delegation.ComponentValidator;
import org.shept.org.springframework.web.servlet.mvc.delegation.configuration.SegmentConfiguration;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.springframework.web.bind.support.WebRequestDataBinder;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;

public class ComponentDataBinder
extends WebRequestDataBinder {
    @Deprecated
    private Map<String, ComponentValidator> validatorsForPath;

    public ComponentDataBinder(Object target) {
        super(target);
    }

    public ComponentDataBinder(Object target, String objectName) {
        super(target, objectName);
    }

    public void bindAndValidate(ServletWebRequest request, ComponentToken token) {
        SegmentConfiguration config;
        this.bind((WebRequest)request);
        String componentPath = ComponentUtils.lookupComponentPath(token);
        BindingResult errors = this.getBindingResult();
        errors.pushNestedPath(componentPath);
        ComponentValidator val = this.getValidator(componentPath);
        if (val != null) {
            val.validate(this.getTarget(), (Errors)this.getBindingResult(), componentPath);
        }
        if ((config = ComponentUtils.getConfiguration(request.getRequest(), token)) != null && config.getValidators() != null) {
            for (ComponentValidator validator : config.getValidators()) {
                validator.validate(this.getTarget(), (Errors)this.getBindingResult(), componentPath);
            }
        }
        errors.popNestedPath();
    }

    public void validate() {
        throw new UnsupportedOperationException("The component binder does not support a global validation. Use a component based validation instead");
    }

    public Validator getValidator() {
        throw new UnsupportedOperationException("The component binder does not support a global validator. Use a component based validatior instead");
    }

    public void setValidator(String path, ComponentValidator validator) {
        this.getValidatorsForPath().put(path, validator);
    }

    @Deprecated
    public ComponentValidator getValidator(String path) {
        return this.getValidatorsForPath().get(path);
    }

    @Deprecated
    public Map<String, ComponentValidator> getValidatorsForPath() {
        if (this.validatorsForPath == null) {
            this.setValidatorsForPath(new LinkedHashMap<String, ComponentValidator>(1));
        }
        return this.validatorsForPath;
    }

    @Deprecated
    public void setValidatorsForPath(Map<String, ComponentValidator> validatorsForPath) {
        this.validatorsForPath = validatorsForPath;
    }
}

