/*
 * Decompiled with CFR 0.152.
 */
package org.shept.org.springframework.web.bind.support;

import java.beans.PropertyEditor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.shept.org.springframework.beans.CustomCalendarEditor;
import org.shept.org.springframework.beans.PropertyEditorHolder;
import org.shept.org.springframework.beans.support.CommandWrapper;
import org.shept.org.springframework.beans.support.FilteredListHolder;
import org.shept.org.springframework.beans.support.PageableList;
import org.shept.org.springframework.web.bind.support.ComponentBindingInitializer;
import org.shept.org.springframework.web.bind.support.ComponentDataBinder;
import org.shept.org.springframework.web.bind.support.FilterBindingInitializer;
import org.shept.org.springframework.web.servlet.mvc.delegation.ComponentUtils;
import org.shept.org.springframework.web.servlet.mvc.delegation.ComponentValidator;
import org.shept.org.springframework.web.servlet.mvc.delegation.SubCommandProvider;
import org.shept.org.springframework.web.servlet.mvc.support.ConfigurableLocaleDependentFormatResolver;
import org.shept.org.springframework.web.servlet.mvc.support.DateTimeLocaleConstants;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.support.RequestContextUtils;

public class DefaultComponentBindingInitializer
implements ComponentBindingInitializer,
InitializingBean {
    private ConfigurableLocaleDependentFormatResolver formatResolver;
    private Map<String, DateTimeLocaleConstants> dateEditors;
    private Map<String, DateTimeLocaleConstants> calendarEditors;
    private Map<String, PropertyEditorHolder> customEditors;
    private Map<Class<?>, ComponentBindingInitializer> initializersForType;
    private ComponentValidator validator;
    private boolean pageableListDetection = true;
    private boolean filterDetection = true;

    @Override
    public void initBinder(WebRequest request, ComponentDataBinder binder, String componentPath) {
        String format;
        String fieldPath;
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)((ServletWebRequest)request).getRequest());
        Map<String, CommandWrapper> pathMap = Collections.emptyMap();
        if (binder.getTarget() instanceof SubCommandProvider) {
            pathMap = ComponentUtils.getComponentPathMap((SubCommandProvider)binder.getTarget());
        }
        if (this.getCustomEditors() != null) {
            for (Map.Entry<String, Object> entry : this.getCustomEditors().entrySet()) {
                fieldPath = this.getFieldPath(componentPath, pathMap);
                binder.registerCustomEditor(((PropertyEditorHolder)entry.getValue()).getRegisteredType(), fieldPath + entry.getKey(), ((PropertyEditorHolder)entry.getValue()).getPropertyEditor());
            }
        }
        if (this.getDateEditors() != null) {
            for (Map.Entry<String, Object> entry : this.getDateEditors().entrySet()) {
                fieldPath = this.getFieldPath(componentPath, pathMap);
                format = this.formatResolver.resolveProperty(locale, (DateTimeLocaleConstants)((Object)entry.getValue()));
                binder.registerCustomEditor(Date.class, fieldPath + entry.getKey(), (PropertyEditor)new CustomDateEditor((DateFormat)new SimpleDateFormat(format), true));
            }
        }
        if (this.getCalendarEditors() != null) {
            for (Map.Entry<Object, Object> entry : this.getCalendarEditors().entrySet()) {
                fieldPath = this.getFieldPath(componentPath, pathMap);
                format = this.formatResolver.resolveProperty(locale, (DateTimeLocaleConstants)((Object)entry.getValue()));
                binder.registerCustomEditor(Calendar.class, fieldPath + (String)entry.getKey(), new CustomCalendarEditor(new SimpleDateFormat(format), true));
            }
        }
        if (this.getInitializersForType() != null) {
            for (Map.Entry<Object, Object> entry : this.getInitializersForType().entrySet()) {
                CommandWrapper component = pathMap.get(componentPath);
                if (!((Class)entry.getKey()).isAssignableFrom(component.getCommand().getClass())) continue;
                ((ComponentBindingInitializer)entry.getValue()).initBinder(request, binder, componentPath);
            }
        }
        if (this.validator != null) {
            binder.setValidator(componentPath, this.validator);
        }
    }

    protected String getFieldPath(String path, Map<String, CommandWrapper> pathMap) {
        String fieldPath = "";
        if (StringUtils.hasText((String)path)) {
            fieldPath = ComponentUtils.getPropertyPathPrefix(path);
            CommandWrapper wrapper = pathMap.get(path);
            if (wrapper != null && wrapper.getCommand() instanceof PageableList && this.pageableListDetection) {
                fieldPath = fieldPath + "source" + ".";
            }
        }
        return fieldPath;
    }

    public Map<String, PropertyEditorHolder> getCustomEditors() {
        if (this.customEditors == null) {
            this.setCustomEditors(new LinkedHashMap<String, PropertyEditorHolder>(1));
        }
        return this.customEditors;
    }

    public void setCustomEditors(Map<String, PropertyEditorHolder> customEditorsForPath) {
        this.customEditors = customEditorsForPath;
    }

    public Map<String, DateTimeLocaleConstants> getDateEditors() {
        if (this.dateEditors == null) {
            this.setDateEditors(new LinkedHashMap<String, DateTimeLocaleConstants>(1));
        }
        return this.dateEditors;
    }

    public void setDateEditors(Map<String, DateTimeLocaleConstants> dateEditors) {
        this.dateEditors = dateEditors;
    }

    public Map<String, DateTimeLocaleConstants> getCalendarEditors() {
        if (this.calendarEditors == null) {
            this.setCalendarEditors(new LinkedHashMap<String, DateTimeLocaleConstants>(1));
        }
        return this.calendarEditors;
    }

    public void setCalendarEditors(Map<String, DateTimeLocaleConstants> calendarEditors) {
        this.calendarEditors = calendarEditors;
    }

    public ConfigurableLocaleDependentFormatResolver getFormatResolver() {
        return this.formatResolver;
    }

    public void setFormatResolver(ConfigurableLocaleDependentFormatResolver formatResolver) {
        this.formatResolver = formatResolver;
    }

    public boolean isPageableListDetection() {
        return this.pageableListDetection;
    }

    public void setPageableListDetection(boolean pageableListDetection) {
        this.pageableListDetection = pageableListDetection;
    }

    public Map<Class<?>, ComponentBindingInitializer> getInitializersForType() {
        if (this.initializersForType == null) {
            this.setInitializersForType(new LinkedHashMap(1));
        }
        return this.initializersForType;
    }

    public void setInitializersForType(Map<Class<?>, ComponentBindingInitializer> initializersForType) {
        this.initializersForType = initializersForType;
    }

    public boolean isFilterDetection() {
        return this.filterDetection;
    }

    public void setFilterDetection(boolean filterDetection) {
        this.filterDetection = filterDetection;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.isFilterDetection() && !this.getInitializersForType().containsKey(FilteredListHolder.class)) {
            FilterBindingInitializer fbi = new FilterBindingInitializer();
            fbi.setFormatResolver(this.getFormatResolver());
            this.getInitializersForType().put(FilteredListHolder.class, fbi);
        }
    }

    public ComponentValidator getValidator() {
        return this.validator;
    }

    public void setValidator(ComponentValidator validator) {
        this.validator = validator;
    }
}

