/*
 * Decompiled with CFR 0.152.
 */
package org.shept.org.springframework.web.bind.support;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.shept.org.springframework.beans.CustomCalendarEditor;
import org.shept.org.springframework.web.servlet.mvc.support.ConfigurableLocaleDependentFormatResolver;
import org.shept.org.springframework.web.servlet.mvc.support.DateTimeLocaleConstants;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.support.RequestContextUtils;

public class DefaultWebBindingInitializer
implements WebBindingInitializer {
    private static final DateTimeLocaleConstants DEFAULT_DATE_TIME = DateTimeLocaleConstants.DATETIME_FORMAT_SHORT;
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ConfigurableLocaleDependentFormatResolver formatResolver;
    private Map<Class<?>, PropertyEditorSupport> customEditorsForType;
    private boolean registerDefaultEditors = true;
    private DateTimeLocaleConstants dateTimeFormat = DEFAULT_DATE_TIME;

    public void initBinder(WebDataBinder binder, WebRequest request) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"Register custom binding initializers");
        }
        if (this.getCustomEditorsForType() != null) {
            for (Map.Entry<Class<?>, PropertyEditorSupport> editorEntry : this.getCustomEditorsForType().entrySet()) {
                binder.registerCustomEditor(editorEntry.getKey(), (PropertyEditor)editorEntry.getValue());
            }
        }
        if (this.isRegisterDefaultEditors()) {
            Locale locale = RequestContextUtils.getLocale((HttpServletRequest)((ServletWebRequest)request).getRequest());
            String format = this.formatResolver.resolveProperty(locale, this.getDateTimeFormat());
            binder.registerCustomEditor(Calendar.class, (PropertyEditor)new CustomCalendarEditor(new SimpleDateFormat(format), true));
            binder.registerCustomEditor(Date.class, (PropertyEditor)new CustomDateEditor((DateFormat)new SimpleDateFormat(format), true));
        }
    }

    public ConfigurableLocaleDependentFormatResolver getFormatResolver() {
        return this.formatResolver;
    }

    public void setFormatResolver(ConfigurableLocaleDependentFormatResolver formatResolver) {
        this.formatResolver = formatResolver;
    }

    public boolean isRegisterDefaultEditors() {
        return this.registerDefaultEditors;
    }

    public void setRegisterDefaultEditors(boolean registerDefaultEditors) {
        this.registerDefaultEditors = registerDefaultEditors;
    }

    public Map<Class<?>, PropertyEditorSupport> getCustomEditorsForType() {
        if (this.customEditorsForType == null) {
            this.setCustomEditorsForType(new LinkedHashMap(1));
        }
        return this.customEditorsForType;
    }

    public void setCustomEditorsForType(Map<Class<?>, PropertyEditorSupport> customEditorsForType) {
        this.customEditorsForType = customEditorsForType;
    }

    public DateTimeLocaleConstants getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public void setDateTimeFormat(DateTimeLocaleConstants dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
    }
}

