/*
 * Decompiled with CFR 0.152.
 */
package org.shept.org.springframework.web.bind.support;

import java.beans.PropertyEditor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import javax.persistence.Entity;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.shept.beans.support.FilterDefinition;
import org.shept.org.springframework.beans.CustomCalendarEditor;
import org.shept.org.springframework.beans.support.CommandWrapper;
import org.shept.org.springframework.beans.support.FilteredListHolder;
import org.shept.org.springframework.web.bind.support.ComponentBindingInitializer;
import org.shept.org.springframework.web.bind.support.ComponentDataBinder;
import org.shept.org.springframework.web.servlet.mvc.delegation.ComponentUtils;
import org.shept.org.springframework.web.servlet.mvc.delegation.SubCommandProvider;
import org.shept.org.springframework.web.servlet.mvc.support.ConfigurableLocaleDependentFormatResolver;
import org.shept.org.springframework.web.servlet.mvc.support.DateTimeLocaleConstants;
import org.springframework.beans.propertyeditors.StringTrimmerEditor;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.support.RequestContextUtils;

public class FilterBindingInitializer
implements ComponentBindingInitializer {
    protected static final Log logger = LogFactory.getLog(FilterBindingInitializer.class);
    protected static final Integer MAX_DEPTH = 5;
    private Integer maxDepth = MAX_DEPTH;
    private ConfigurableLocaleDependentFormatResolver formatResolver;

    @Override
    public void initBinder(WebRequest request, ComponentDataBinder binder, String componentPath) {
        CommandWrapper wrapper;
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Register custom binding initializers");
        }
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)((ServletWebRequest)request).getRequest());
        String format = this.formatResolver.resolveProperty(locale, DateTimeLocaleConstants.DATETIME_FORMAT_LONG);
        Map<Object, Object> pathMap = Collections.emptyMap();
        if (binder.getTarget() instanceof SubCommandProvider && (wrapper = (CommandWrapper)(pathMap = ComponentUtils.getComponentPathMap((SubCommandProvider)binder.getTarget())).get(componentPath)).getCommand() instanceof FilteredListHolder) {
            FilteredListHolder flh = (FilteredListHolder)wrapper.getCommand();
            FilterDefinition filterDef = flh.getFilter();
            String path = ComponentUtils.getPropertyPathPrefix(componentPath) + "filter" + ".";
            for (Field field : filterDef.getClass().getDeclaredFields()) {
                String propPath = path + field.getName();
                if (field.getType().equals(String.class)) {
                    binder.registerCustomEditor(String.class, propPath, (PropertyEditor)new StringTrimmerEditor(true));
                    if (!logger.isInfoEnabled()) continue;
                    logger.info((Object)("Registered nullable StringEditor for " + propPath));
                    continue;
                }
                if (field.getType().equals(Calendar.class)) {
                    format = this.formatResolver.resolveProperty(locale, DateTimeLocaleConstants.DATE_FORMAT_SHORT);
                    binder.registerCustomEditor(Calendar.class, propPath, new CustomCalendarEditor(new SimpleDateFormat(format), true));
                    if (!logger.isInfoEnabled()) continue;
                    logger.info((Object)("Registered Calendar Editor for " + propPath));
                    continue;
                }
                this.registerDependendEntities(binder, field.getType(), path + field.getName());
            }
        }
    }

    private void registerDependendEntities(ComponentDataBinder binder, Class clazz, String path) {
        Annotation ann = AnnotationUtils.findAnnotation((Class)clazz, Entity.class);
        if (ann == null) {
            return;
        }
        for (Field field : clazz.getDeclaredFields()) {
            String propPath = path + "." + field.getName();
            if (field.getType().equals(String.class)) {
                binder.registerCustomEditor(String.class, propPath, (PropertyEditor)new StringTrimmerEditor(true));
                if (!logger.isInfoEnabled()) continue;
                logger.info((Object)("Registered nullable StringEditor for " + propPath));
                continue;
            }
            Integer depth = StringUtils.countOccurrencesOf((String)path, (String)".");
            if (depth > this.maxDepth) continue;
            this.registerDependendEntities(binder, field.getType(), propPath);
        }
    }

    public ConfigurableLocaleDependentFormatResolver getFormatResolver() {
        return this.formatResolver;
    }

    public void setFormatResolver(ConfigurableLocaleDependentFormatResolver formatResolver) {
        this.formatResolver = formatResolver;
    }

    public void setMaxDepth(Integer maxDepth) {
        this.maxDepth = maxDepth;
    }
}

