/*
 * Decompiled with CFR 0.152.
 */
package org.shept.org.springframework.web.servlet.mvc.delegation;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.persistence.Entity;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.shept.org.springframework.beans.support.CommandWrapper;
import org.shept.org.springframework.beans.support.MultiChoice;
import org.shept.org.springframework.beans.support.PageableList;
import org.shept.org.springframework.web.servlet.mvc.delegation.ComponentToken;
import org.shept.org.springframework.web.servlet.mvc.delegation.SubCommandProvider;
import org.shept.org.springframework.web.servlet.mvc.delegation.configuration.ChainConfiguration;
import org.shept.org.springframework.web.servlet.mvc.delegation.configuration.DataGridConfiguration;
import org.shept.org.springframework.web.servlet.mvc.delegation.configuration.SegmentConfiguration;
import org.shept.org.springframework.web.servlet.mvc.delegation.configuration.SheptBean;
import org.shept.org.springframework.web.servlet.mvc.delegation.configuration.TargetConfiguration;
import org.shept.org.springframework.web.servlet.mvc.support.InfoItem;
import org.shept.org.springframework.web.servlet.mvc.support.ModelUtils;
import org.shept.org.springframework.web.servlet.mvc.support.RequestValueUtils;
import org.shept.util.SheptBeanFactoryUtils;
import org.shept.util.StringUtilsExtended;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.BindingResultUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.support.RequestContextUtils;

public abstract class ComponentUtils {
    protected static Log logger = LogFactory.getLog(ComponentUtils.class);
    public static String DEFAULT_SELECTOR = "";

    public static Object getModel(ComponentToken token) {
        if (token == null) {
            return null;
        }
        Object model = null;
        Object unwrapped = ModelUtils.unwrapIfNecessary(token.getComponent());
        if (null != AnnotationUtils.findAnnotation(unwrapped.getClass(), Entity.class)) {
            model = unwrapped;
        }
        if (model == null) {
            model = ModelUtils.unwrapIfNecessary(ComponentUtils.getModelFromList(token));
        }
        return model;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object getModelFromList(ComponentToken token) {
        Object model = null;
        String val = token.getToken().getValue();
        Integer index = -1;
        try {
            index = Integer.valueOf(val);
        }
        catch (Exception e) {
            RequestValueUtils.ChainParameter jp = RequestValueUtils.getChainParameter(val);
            if (jp.isIndexed()) {
                index = jp.getIndex();
            }
            logger.info((Object)("Trying to find an object model index but there is no index specified in token " + token.toString()));
        }
        if (index == -1) {
            return null;
        }
        PageableList pagedList = null;
        if (PageableList.class.isAssignableFrom(token.getComponent().getClass())) {
            pagedList = (PageableList)token.getComponent();
            if (pagedList.isVisible(index)) {
                return pagedList.getSource().get(index);
            }
            if (!logger.isErrorEnabled()) return null;
            logger.error((Object)("The index " + index.toString() + " is not visible within the boundaries of the pagedList (" + String.valueOf(pagedList.getFirstElementOnPage()) + "-" + String.valueOf(pagedList.getLastElementOnPage()) + ")"));
            return null;
        }
        if (!logger.isErrorEnabled()) return model;
        logger.error((Object)("The token component does not implement PageableList so we cannot extract a row object from list. Token is: " + token.toString()));
        return model;
    }

    public static List<?> getModelsSelected(ComponentToken token) {
        if (!(token.getComponent() instanceof MultiChoice)) {
            return Collections.EMPTY_LIST;
        }
        return ((MultiChoice)token.getComponent()).getSelectedItems();
    }

    public static int lookupComponentIndex(ComponentToken token) {
        if (!(token.getCommand() instanceof SubCommandProvider)) {
            return -1;
        }
        SubCommandProvider scp = (SubCommandProvider)token.getCommand();
        for (int i = 0; i < scp.getChildren().size(); ++i) {
            CommandWrapper cmdWr = scp.getChildren().get(i);
            if (!cmdWr.getCommand().equals(token.getComponent())) continue;
            return i;
        }
        return 0;
    }

    public static String lookupComponentPath(ComponentToken token) {
        if (!(token.getCommand() instanceof SubCommandProvider)) {
            return "";
        }
        SubCommandProvider scp = (SubCommandProvider)token.getCommand();
        for (Map.Entry<String, Object> pathAndCommand : scp.getSubCommands().entrySet()) {
            if (!pathAndCommand.getValue().equals(token.getComponent())) continue;
            return pathAndCommand.getKey();
        }
        return "";
    }

    public static Map<String, CommandWrapper> getComponentPathMap(SubCommandProvider command) {
        Map<String, Object> cmdMap = command.getSubCommands();
        String[] cmdPath = cmdMap.keySet().toArray(new String[0]);
        LinkedHashMap<String, CommandWrapper> pathMap = new LinkedHashMap<String, CommandWrapper>();
        for (int i = 0; i < cmdMap.size(); ++i) {
            pathMap.put(cmdPath[i], command.getChildren().get(i));
        }
        return pathMap;
    }

    public static CommandWrapper lookupComponentWrapper(ComponentToken token) {
        return ComponentUtils.lookupComponentWrapper(token, 0);
    }

    public static CommandWrapper lookupComponentWrapper(ComponentToken token, int offset) {
        if (!(token.getCommand() instanceof SubCommandProvider)) {
            return null;
        }
        SubCommandProvider scp = (SubCommandProvider)token.getCommand();
        Integer idx = ComponentUtils.lookupComponentIndex(token);
        return scp.getChildren().get(idx + offset);
    }

    public static int removeComponentsAfterIndex(ComponentToken token, Integer index) {
        if (!(token.getCommand() instanceof SubCommandProvider)) {
            return -1;
        }
        SubCommandProvider scp = (SubCommandProvider)token.getCommand();
        List<CommandWrapper> children = scp.getChildren();
        Integer idx = index;
        if (index == null) {
            idx = ComponentUtils.lookupComponentIndex(token);
        }
        idx = Math.min(idx, children.size() - 1);
        while (children.size() - 1 > idx) {
            scp.getChildren().remove(children.size() - 1);
        }
        return idx;
    }

    public static int addComponent(ComponentToken token, CommandWrapper wrapper) {
        return ComponentUtils.addComponent(token, wrapper, null);
    }

    public static int addComponent(ComponentToken token, CommandWrapper wrapper, Integer index) {
        if (!(token.getCommand() instanceof SubCommandProvider)) {
            return -1;
        }
        SubCommandProvider scp = (SubCommandProvider)token.getCommand();
        List<CommandWrapper> children = scp.getChildren();
        Integer idx = index;
        if (index == null) {
            idx = ComponentUtils.lookupComponentIndex(token);
        }
        idx = Math.min(idx, children.size() - 1) + 1;
        scp.getChildren().add(idx, wrapper);
        return idx;
    }

    public static SegmentConfiguration getConfiguration(ApplicationContext ctx, String tagName) {
        SegmentConfiguration config = null;
        try {
            config = (SegmentConfiguration)ctx.getBean(tagName, SegmentConfiguration.class);
        }
        catch (BeansException beansException) {
            // empty catch block
        }
        return config;
    }

    public static void applyConfiguration(CommandWrapper wrapper, ApplicationContext ctx) {
        SegmentConfiguration config = ComponentUtils.getConfiguration(ctx, wrapper.getTagName());
        if (config instanceof DataGridConfiguration && wrapper.getCommand() instanceof PageableList) {
            PageableList listHolder = (PageableList)wrapper.getCommand();
            DataGridConfiguration listConfig = (DataGridConfiguration)config;
            if (listConfig.getNewModelSize() != null && listHolder.getNewModelSize() == 1) {
                listHolder.setNewModelSize(listConfig.getNewModelSize());
            }
            if (listConfig.getPageSize() != null && listHolder.getPageSize() == 10) {
                listHolder.setPageSize(listConfig.getPageSize());
            }
        }
    }

    public static String getComponentInfo(HttpServletRequest request, InfoItem item, Object model) {
        Method mth;
        if (item == null) {
            return null;
        }
        if (item.getCode() == null) {
            return null;
        }
        WebApplicationContext ctx = RequestContextUtils.getWebApplicationContext((ServletRequest)request);
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        String arg = null;
        if (model != null && StringUtils.hasText((String)item.getSelector()) && (mth = ReflectionUtils.findMethod(model.getClass(), (String)StringUtilsExtended.getReadAccessor(item.getSelector()))) != null) {
            arg = (String)ReflectionUtils.invokeMethod((Method)mth, (Object)model);
        }
        if (StringUtils.hasText(arg)) {
            return ctx.getMessage(item.getCode(), (Object[])new String[]{arg}, "???", locale);
        }
        return ctx.getMessage(item.getCode(), null, "???", locale);
    }

    public static String getComponentInfo(HttpServletRequest request, TargetConfiguration cc, Object model) {
        return ComponentUtils.getComponentInfo(request, cc.getInfo(), model);
    }

    public static SegmentConfiguration getConfiguration(ApplicationContext ctx, CommandWrapper wrapper) {
        return ComponentUtils.getConfiguration(ctx, wrapper.getTagName());
    }

    public static SegmentConfiguration getConfiguration(ApplicationContext ctx, ComponentToken token) {
        CommandWrapper wrapper = ComponentUtils.lookupComponentWrapper(token);
        if (wrapper == null) {
            return null;
        }
        return ComponentUtils.getConfiguration(ctx, wrapper);
    }

    public static SegmentConfiguration getConfiguration(HttpServletRequest request, CommandWrapper wrapper) {
        WebApplicationContext ctx = RequestContextUtils.getWebApplicationContext((ServletRequest)request);
        if (ctx == null) {
            return null;
        }
        return ComponentUtils.getConfiguration((ApplicationContext)ctx, wrapper);
    }

    public static SegmentConfiguration getConfiguration(HttpServletRequest request, ComponentToken token) {
        CommandWrapper wrapper = ComponentUtils.lookupComponentWrapper(token);
        if (wrapper == null) {
            return null;
        }
        return ComponentUtils.getConfiguration(request, wrapper);
    }

    public static TargetConfiguration getChainConfiguration(HttpServletRequest request, ComponentToken token) {
        WebApplicationContext ctx = RequestContextUtils.getWebApplicationContext((ServletRequest)request);
        if (ctx == null) {
            return null;
        }
        return ComponentUtils.getChainConfiguration((ApplicationContext)ctx, token);
    }

    public static TargetConfiguration getChainConfiguration(ApplicationContext ctx, ComponentToken token) {
        String sourceName;
        RequestValueUtils.ChainParameter jp = RequestValueUtils.getChainParameter(token.getToken().getValue());
        String linkName = jp.getName();
        TargetConfiguration tc = ComponentUtils.getChainConfiguration(ctx, linkName, sourceName = ComponentUtils.lookupComponentWrapper(token).getTagName());
        if (tc != null) {
            return tc;
        }
        String parentName = SheptBeanFactoryUtils.getParentBeanName(ctx, sourceName);
        while (parentName != null) {
            tc = ComponentUtils.getChainConfiguration(ctx, linkName, parentName);
            if (tc != null) {
                return tc;
            }
            parentName = SheptBeanFactoryUtils.getParentBeanName(ctx, parentName);
        }
        String errStr = "No chain configuration found for link: '" + linkName + "' from source: '" + sourceName + "'";
        if (parentName != null) {
            errStr = errStr + " parent: '" + parentName + "'";
        }
        logger.error((Object)errStr);
        return null;
    }

    private static TargetConfiguration getChainConfiguration(ApplicationContext ctx, String linkName, String sourceName) {
        List<TargetConfiguration> chains = ComponentUtils.getChainConfigurations(ctx, sourceName);
        for (TargetConfiguration cc : chains) {
            if (!StringUtils.hasText((String)cc.getBeanName()) || !cc.getBeanName().equals(linkName)) continue;
            logger.info((Object)("Chain configuration found for (chain-)bean named '" + linkName + "' from source '" + sourceName + "'"));
            return cc;
        }
        String relName = linkName;
        if (!relName.startsWith("get")) {
            relName = "get" + StringUtils.capitalize((String)relName);
        }
        for (TargetConfiguration cc : chains) {
            String rel;
            if (!(cc instanceof ChainConfiguration) || !StringUtils.hasText((String)(rel = ((ChainConfiguration)cc).getRelation())) || !rel.equals(relName)) continue;
            logger.info((Object)("Chain configuration found for relation named '" + linkName + "' from source '" + sourceName + "'"));
            return cc;
        }
        for (TargetConfiguration cc : chains) {
            if (!StringUtils.hasText((String)cc.getTo().getBeanName()) || !cc.getTo().getBeanName().equals(linkName)) continue;
            logger.info((Object)("Chain configuration found for target bean named '" + linkName + "' from source '" + sourceName + "'"));
            return cc;
        }
        return null;
    }

    protected static List<TargetConfiguration> getChainConfigurations(ApplicationContext ctx, String sourceName) {
        List allChains = (List)ctx.getBean(SheptBean.CHAINS.getBeanName());
        ArrayList<TargetConfiguration> chains = new ArrayList<TargetConfiguration>();
        for (TargetConfiguration tC : allChains) {
            if (!(tC instanceof ChainConfiguration) || !((ChainConfiguration)tC).getFrom().getBeanName().equals(sourceName)) continue;
            chains.add(tC);
        }
        return chains;
    }

    public static String getChainConfigurationErrorMessage(HttpServletRequest request, ComponentToken token) {
        WebApplicationContext ctx = RequestContextUtils.getWebApplicationContext((ServletRequest)request);
        if (ctx == null) {
            return "";
        }
        return ComponentUtils.getChainConfigurationErrorMessage((ApplicationContext)ctx, token);
    }

    public static String getChainConfigurationErrorMessage(ApplicationContext ctx, ComponentToken token) {
        SegmentConfiguration config = ComponentUtils.getConfiguration(ctx, token);
        RequestValueUtils.ChainParameter jp = RequestValueUtils.getChainParameter(token.getToken().getValue());
        String linkName = jp.getName();
        return "Missing chain configuration in '" + config.getBeanName() + "' for '" + linkName + "'";
    }

    public static String getPropertyPathPrefix(String pathName) {
        if (StringUtils.hasLength((String)pathName) && !pathName.endsWith(".")) {
            pathName = pathName + ".";
        }
        return pathName;
    }

    public static Object getComponent(Object target, String pathName) {
        Object component = null;
        if (target instanceof SubCommandProvider) {
            Map<String, CommandWrapper> pathMap = ComponentUtils.getComponentPathMap((SubCommandProvider)target);
            CommandWrapper wrapper = pathMap.get(pathName);
            component = wrapper.getCommand();
        }
        return component;
    }

    public static SubCommandProvider getCommand(ModelAndView modelAndView) {
        String prefix = BindingResult.MODEL_KEY_PREFIX;
        if (modelAndView == null) {
            return null;
        }
        for (String name : modelAndView.getModel().keySet()) {
            BindingResult res;
            if (!name.startsWith(prefix) || (res = BindingResultUtils.getBindingResult((Map)modelAndView.getModel(), (String)name.substring(prefix.length()))) == null || !(res.getTarget() instanceof SubCommandProvider)) continue;
            return (SubCommandProvider)res.getTarget();
        }
        return null;
    }

    public static Object getComponent(ModelAndView modelAndView, String pathName) {
        SubCommandProvider command = ComponentUtils.getCommand(modelAndView);
        return ComponentUtils.getComponent(command, pathName);
    }
}

