/*
 * Decompiled with CFR 0.152.
 */
package org.shept.org.springframework.web.servlet.mvc.delegation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.shept.org.springframework.beans.support.CommandWrapper;
import org.shept.org.springframework.web.bind.support.ComponentBindingInitializer;
import org.shept.org.springframework.web.bind.support.ComponentDataBinder;
import org.shept.org.springframework.web.bind.support.ComponentPostprocessor;
import org.shept.org.springframework.web.servlet.mvc.delegation.ComponentToken;
import org.shept.org.springframework.web.servlet.mvc.delegation.ComponentUtils;
import org.shept.org.springframework.web.servlet.mvc.delegation.SubCommandProvider;
import org.shept.org.springframework.web.servlet.mvc.delegation.SubmitActionResolver;
import org.shept.org.springframework.web.servlet.mvc.delegation.WebActionResolver;
import org.shept.org.springframework.web.servlet.mvc.delegation.WebActionToken;
import org.shept.org.springframework.web.servlet.mvc.delegation.component.WebComponent;
import org.shept.org.springframework.web.servlet.mvc.delegation.configuration.SegmentConfiguration;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.AbstractController;
import org.springframework.web.servlet.mvc.LastModified;
import org.springframework.web.servlet.mvc.multiaction.NoSuchRequestHandlingMethodException;
import org.springframework.web.servlet.view.RedirectView;

public class DelegatingController
extends AbstractController
implements LastModified,
BeanNameAware,
InitializingBean {
    public static final String LAST_MODIFIED_METHOD_SUFFIX = "LastModified";
    public static final String DEFAULT_COMMAND_NAME = "command";
    public static final String PAGE_NOT_FOUND_LOG_CATEGORY = "org.springframework.web.servlet.PageNotFound";
    protected static final Log pageNotFoundLogger = LogFactory.getLog((String)"org.springframework.web.servlet.PageNotFound");
    private WebActionResolver actionResolver = new SubmitActionResolver();
    private WebBindingInitializer webBindingInitializer;
    private WebComponent[] delegates;
    private String redirectUrl;
    private String formView;
    private Class<Object> commandClass;

    public void setActionResolver(WebActionResolver actionResolver) {
        this.actionResolver = actionResolver;
    }

    public void setDelegates(WebComponent[] delegates) {
        this.delegates = delegates;
    }

    public void setCommandClass(Class<Object> commandClass) {
        this.commandClass = commandClass;
    }

    public final void setWebBindingInitializer(WebBindingInitializer webBindingInitializer) {
        this.webBindingInitializer = webBindingInitializer;
    }

    public final WebBindingInitializer getWebBindingInitializer() {
        return this.webBindingInitializer;
    }

    public long getLastModified(HttpServletRequest request) {
        return -1L;
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            Object command = this.getCommandObject(request, this.commandClass);
            Map<Object, Object> components = new HashMap<String, Object>();
            if (command instanceof SubCommandProvider) {
                SubCommandProvider cp = (SubCommandProvider)command;
                components = cp.getSubCommands();
            }
            components.put("", command);
            components = this.prepareComponentPathForLookup(components);
            HashMap<String, List<WebComponent>> handlersForPath = new HashMap<String, List<WebComponent>>();
            for (Map.Entry<Object, Object> component : components.entrySet()) {
                for (WebComponent handler : this.delegates) {
                    if (component.getValue() == null || !handler.supports(component.getValue())) continue;
                    ArrayList<WebComponent> handlers = (ArrayList<WebComponent>)handlersForPath.get(component.getKey());
                    if (handlers == null) {
                        handlers = new ArrayList<WebComponent>();
                        handlersForPath.put((String)component.getKey(), handlers);
                    }
                    handlers.add(handler);
                }
            }
            WebActionToken token = this.actionResolver.getAction(request, components.keySet(), handlersForPath);
            ComponentDataBinder binder = this.createBinder(request, command);
            ModelAndView mav = new ModelAndView(this.getFormView(), binder.getBindingResult().getModel());
            if (token != null) {
                ComponentToken comToken = new ComponentToken();
                comToken.setComponent(components.get(token.getPathName()));
                comToken.setToken(token);
                comToken.setBinder(binder);
                this.logger.info((Object)("Processing input " + comToken));
                ModelAndView rv = token.getHandler().excecuteAction(request, response, comToken);
                mav = this.massageReturnValueIfNecessary(rv);
                if (mav != null && !mav.hasView()) {
                    mav.setViewName(this.getFormView());
                }
            }
            this.postProcessModel(request, mav);
            return mav;
        }
        catch (NoSuchRequestHandlingMethodException ex) {
            return this.handleNoSuchRequestHandlingMethod(ex, request, response);
        }
    }

    private Map<String, Object> prepareComponentPathForLookup(Map<String, Object> components) {
        Map copy = (Map)BeanUtils.instantiate(components.getClass());
        for (String pathName : components.keySet()) {
            Object object = components.get(pathName);
            pathName = ComponentUtils.getPropertyPathPrefix(pathName);
            copy.put(pathName, object);
        }
        return copy;
    }

    protected ModelAndView handleNoSuchRequestHandlingMethod(NoSuchRequestHandlingMethodException ex, HttpServletRequest request, HttpServletResponse response) throws Exception {
        pageNotFoundLogger.warn((Object)ex.getMessage());
        response.sendError(404);
        return null;
    }

    protected ModelAndView massageReturnValueIfNecessary(Object returnValue) {
        if (returnValue instanceof ModelAndView) {
            ModelAndView mav = (ModelAndView)returnValue;
            if (mav.getView() instanceof RedirectView) {
                RedirectView view = (RedirectView)mav.getView();
                String fragment = "";
                String url = view.getUrl();
                if (StringUtils.hasText((String)url) && url.startsWith("#")) {
                    fragment = url;
                    url = "";
                }
                if (!StringUtils.hasText((String)url)) {
                    url = this.getRedirectUrl();
                    if (StringUtils.hasText((String)fragment)) {
                        url = url + fragment;
                    }
                    mav.setView((View)new RedirectView(url, true, true, false));
                }
                return mav;
            }
            if (!mav.hasView()) {
                mav.setViewName(this.getFormView());
            }
            return mav;
        }
        if (returnValue instanceof Map) {
            return new ModelAndView(this.getFormView(), (Map)returnValue);
        }
        if (returnValue instanceof String) {
            return new ModelAndView((String)returnValue);
        }
        return null;
    }

    protected Object getCommandObject(HttpServletRequest request, Class clazz) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating new command of class [" + clazz.getName() + "]"));
        }
        return BeanUtils.instantiateClass((Class)clazz);
    }

    protected ComponentDataBinder createBinder(HttpServletRequest request, Object command) throws Exception {
        ComponentDataBinder binder = new ComponentDataBinder(command, this.getCommandName(command));
        this.initBinder(request, binder);
        return binder;
    }

    protected String getCommandName(Object command) {
        return DEFAULT_COMMAND_NAME;
    }

    protected void initBinder(HttpServletRequest request, ComponentDataBinder binder) throws Exception {
        if (this.webBindingInitializer != null) {
            this.webBindingInitializer.initBinder((WebDataBinder)binder, (WebRequest)new ServletWebRequest(request));
        }
        if (binder.getTarget() instanceof SubCommandProvider) {
            Map<String, CommandWrapper> pathMap = ComponentUtils.getComponentPathMap((SubCommandProvider)binder.getTarget());
            for (Map.Entry<String, CommandWrapper> entry : pathMap.entrySet()) {
                String name = entry.getValue().getTagName();
                SegmentConfiguration config = ComponentUtils.getConfiguration((ApplicationContext)this.getWebApplicationContext(), name);
                if (config == null || config.getComponentBindingInitializers() == null) continue;
                for (ComponentBindingInitializer bindInitializer : config.getComponentBindingInitializers()) {
                    bindInitializer.initBinder((WebRequest)new ServletWebRequest(request), binder, entry.getKey());
                }
            }
        }
    }

    protected void postProcessModel(HttpServletRequest request, ModelAndView modelAndView) throws Exception {
        SubCommandProvider command = ComponentUtils.getCommand(modelAndView);
        if (command != null) {
            Map<String, CommandWrapper> pathMap = ComponentUtils.getComponentPathMap(command);
            for (Map.Entry<String, CommandWrapper> entry : pathMap.entrySet()) {
                String name = entry.getValue().getTagName();
                SegmentConfiguration config = ComponentUtils.getConfiguration((ApplicationContext)this.getWebApplicationContext(), name);
                if (config == null || config.getComponentPostprocessors() == null) continue;
                for (ComponentPostprocessor processor : config.getComponentPostprocessors()) {
                    processor.postHandle((WebRequest)new ServletWebRequest(request), modelAndView, entry.getKey());
                }
            }
        }
    }

    public void setBeanName(String name) {
        if (this.redirectUrl == null) {
            this.setRedirectUrl(name);
        }
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public void setRedirectUrl(String viewName) {
        this.redirectUrl = viewName;
    }

    public void afterPropertiesSet() throws Exception {
        if (this instanceof WebComponent) {
            if (this.delegates == null) {
                this.setDelegates(new WebComponent[]{(WebComponent)((Object)this)});
            } else {
                ArrayList<WebComponent> list = new ArrayList<WebComponent>();
                list.addAll(Arrays.asList(this.delegates));
                list.add((WebComponent)((Object)this));
                this.setDelegates(list.toArray(new WebComponent[0]));
            }
        }
    }

    public String getFormView() {
        return this.formView;
    }

    public void setFormView(String formView) {
        this.formView = formView;
    }
}

