/*
 * Decompiled with CFR 0.152.
 */
package org.shept.org.springframework.web.servlet.mvc.delegation;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.shept.org.springframework.web.bind.support.CommandObjectProvider;
import org.shept.org.springframework.web.servlet.mvc.delegation.DelegatingController;
import org.shept.org.springframework.web.servlet.mvc.formcache.LastModifiedSessionFormCache;
import org.shept.org.springframework.web.servlet.mvc.formcache.SessionFormCache;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

public class MultiActionController
extends DelegatingController {
    private static String CLEAR_FORM_CACHE_PARAM = "clearCache";
    private static String FORM_TITLE_MODEL_ATTRIBUTE = "formTitle";
    protected String clearCacheParam = CLEAR_FORM_CACHE_PARAM;
    protected boolean enableClearCache = true;
    protected SessionFormCache formCache = new LastModifiedSessionFormCache();
    protected CommandObjectProvider objectProvider;
    private String formTitleAttribute = FORM_TITLE_MODEL_ATTRIBUTE;
    private String titleCode = "";

    @Override
    protected Object getCommandObject(HttpServletRequest request, Class clazz) throws Exception {
        Object sessionFormObject = this.formCache.getForm(request, this.getRedirectUrl());
        if (sessionFormObject == null) {
            sessionFormObject = this.buildCommandObject(request);
            this.formCache.saveForm(request, this.getRedirectUrl(), sessionFormObject);
        }
        return sessionFormObject;
    }

    protected Object buildCommandObject(HttpServletRequest request) {
        Object command = this.objectProvider.getObject(request);
        if (command == null) {
            throw new UnsupportedOperationException("Object Provider returned a null object during creation of a new object model in controller handling " + this.getRedirectUrl());
        }
        return command;
    }

    @Override
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String clear = ServletRequestUtils.getStringParameter((ServletRequest)request, (String)this.clearCacheParam, (String)"");
        if (StringUtils.hasText((String)clear) && this.enableClearCache) {
            this.formCache.clearCache(request);
            return new ModelAndView((View)new RedirectView(request.getRequestURI()));
        }
        return super.handleRequestInternal(request, response);
    }

    @Override
    protected void postProcessModel(HttpServletRequest request, ModelAndView mav) throws Exception {
        super.postProcessModel(request, mav);
        if (StringUtils.hasText((String)this.titleCode)) {
            String title = this.getMessageSourceAccessor().getMessage(this.titleCode);
            mav.addObject(this.formTitleAttribute, (Object)title);
        }
    }

    public SessionFormCache getFormCache() {
        return this.formCache;
    }

    public void setFormCache(SessionFormCache formCache) {
        this.formCache = formCache;
    }

    @Override
    public long getLastModified(HttpServletRequest request) {
        return this.formCache.getLastModified(request, this.getRedirectUrl());
    }

    public void setObjectProvider(CommandObjectProvider objectProvider) {
        this.objectProvider = objectProvider;
    }

    public String getClearCacheParam() {
        return this.clearCacheParam;
    }

    public void setClearCacheParam(String clearCacheParam) {
        this.clearCacheParam = clearCacheParam;
    }

    public void setEnableClearCache(boolean enableClearCache) {
        this.enableClearCache = enableClearCache;
    }

    public void setTitleCode(String titleCode) {
        this.titleCode = titleCode;
    }

    public String getFormTitleAttribute() {
        return this.formTitleAttribute;
    }

    public void setFormTitleAttribute(String formTitleAttribute) {
        this.formTitleAttribute = formTitleAttribute;
    }
}

