/*
 * Decompiled with CFR 0.152.
 */
package org.shept.org.springframework.web.servlet.mvc.delegation;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.shept.org.springframework.beans.support.CommandWrapper;
import org.shept.org.springframework.beans.support.DefaultCommandObject;
import org.shept.org.springframework.beans.support.Refreshable;
import org.shept.org.springframework.web.servlet.mvc.delegation.ComponentUtils;
import org.shept.org.springframework.web.servlet.mvc.delegation.MultiActionController;
import org.shept.org.springframework.web.servlet.mvc.delegation.command.CommandFactory;
import org.shept.org.springframework.web.servlet.mvc.delegation.command.TargetCommandFactory;
import org.shept.org.springframework.web.servlet.mvc.delegation.configuration.TargetConfiguration;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.dao.support.DaoSupport;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.ModelAndView;

public class SheptController
extends MultiActionController
implements InitializingBean {
    private TargetConfiguration configuration;
    protected DaoSupport dao;

    @Override
    protected Object buildCommandObject(HttpServletRequest request) {
        DefaultCommandObject dco = new DefaultCommandObject();
        CommandFactory cmdFac = this.configuration.getCommandFactory();
        Object cmd = null;
        cmd = cmdFac instanceof TargetCommandFactory ? ((TargetCommandFactory)cmdFac).getCommand(this.configuration, null) : cmdFac.getCommand(request, null);
        CommandWrapper cw = new CommandWrapper();
        cw.setCommand(cmd);
        cw.setTagName(this.configuration.getTo().getBeanName());
        dco.getChildren().clear();
        dco.getChildren().add(cw);
        ComponentUtils.applyConfiguration(cw, (ApplicationContext)this.getWebApplicationContext());
        if (cw.getCommand() instanceof Refreshable) {
            Refreshable content = (Refreshable)cw.getCommand();
            try {
                content.refresh();
            }
            catch (Exception ex) {
                this.logger.error((Object)("Error while loading content for component '" + cw.getTagName() + "'"), (Throwable)ex);
            }
        }
        return dco;
    }

    @Override
    protected void postProcessModel(HttpServletRequest request, ModelAndView mav) throws Exception {
        super.postProcessModel(request, mav);
        if (!mav.getModelMap().containsAttribute(this.getFormTitleAttribute()) && this.configuration.getInfo() != null && StringUtils.hasText((String)this.configuration.getInfo().getCode())) {
            String title = this.getMessageSourceAccessor().getMessage(this.configuration.getInfo().getCode());
            mav.addObject(this.getFormTitleAttribute(), (Object)title);
        }
    }

    public void setConfiguration(TargetConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void afterPropertiesSet() {
        Assert.notNull((Object)this.configuration);
    }

    public DaoSupport getDao() {
        return this.dao;
    }

    @Resource
    public void setDao(DaoSupport dao) {
        this.dao = dao;
    }
}

