/*
 * Decompiled with CFR 0.152.
 */
package org.shept.org.springframework.web.servlet.mvc.delegation;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.shept.org.springframework.web.servlet.mvc.delegation.WebActionResolver;
import org.shept.org.springframework.web.servlet.mvc.delegation.WebActionToken;
import org.shept.org.springframework.web.servlet.mvc.delegation.component.WebComponent;
import org.springframework.web.util.WebUtils;

public class SubmitActionResolver
implements WebActionResolver {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Map<WebComponent, Map<String, String>> registeredHandlerMappings = new HashMap<WebComponent, Map<String, String>>();

    @Override
    public WebActionToken getAction(HttpServletRequest request, Set<String> componentPathName, Map<String, List<WebComponent>> handlersForPath) {
        if (componentPathName == null) {
            componentPathName = new HashSet<String>();
        }
        LinkedList<String> pathNames = new LinkedList<String>();
        pathNames.addAll(componentPathName);
        Collections.sort(pathNames, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return Integer.valueOf(o2.length()).compareTo(o1.length());
            }
        });
        for (String pathCandidate : pathNames) {
            List<WebComponent> handlers;
            Map params = WebUtils.getParametersStartingWith((ServletRequest)request, (String)pathCandidate);
            if (params.size() <= 0 || (handlers = handlersForPath.get(pathCandidate)) == null) continue;
            for (WebComponent handler : handlers) {
                Map<String, String> mappings = handler.getMappings();
                if (mappings == null) {
                    throw new IllegalStateException("Configuration error for component " + handler.getClass() + " Submission parameters are not mapped to Handlers action (excecution) methods");
                }
                for (String candidate : mappings.keySet()) {
                    String parameterValue = WebUtils.findParameterValue((Map)params, (String)candidate);
                    if (parameterValue == null) continue;
                    WebActionToken token = new WebActionToken();
                    token.setHandler(handler);
                    token.setPathName(pathCandidate);
                    token.setMethod(this.getMappings(handler).get(candidate));
                    token.setValue(parameterValue);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Determined token: " + token));
                    }
                    return token;
                }
            }
        }
        return null;
    }

    protected Map<String, String> getMappings(WebComponent handler) {
        Map<String, String> mappings = this.registeredHandlerMappings.get(handler);
        if (mappings == null) {
            mappings = handler.getMappings();
        }
        return mappings;
    }

    public void setRegisteredHandlerMappings(Map<WebComponent, Map<String, String>> registeredHandlerMappings) {
        this.registeredHandlerMappings = registeredHandlerMappings;
    }
}

