/*
 * Decompiled with CFR 0.152.
 */
package org.shept.org.springframework.web.servlet.mvc.delegation.command;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.shept.org.springframework.web.servlet.mvc.delegation.ComponentToken;
import org.shept.org.springframework.web.servlet.mvc.delegation.ComponentUtils;
import org.shept.org.springframework.web.servlet.mvc.delegation.command.TargetCommandFactory;
import org.shept.org.springframework.web.servlet.mvc.delegation.configuration.TargetConfiguration;
import org.shept.util.PageHolderFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.Assert;

public abstract class AbstractCommandFactory
implements TargetCommandFactory,
ApplicationContextAware,
InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ApplicationContext ctx;
    private PageHolderFactory pageHolderFactory;

    public Object getCommand(ComponentToken token) {
        Object model = ComponentUtils.getModel(token);
        TargetConfiguration cc = ComponentUtils.getChainConfiguration(this.getApplicationContext(), token);
        return this.getCommand(cc, model);
    }

    @Override
    public Object getCommand(HttpServletRequest request, ComponentToken token) {
        return this.getCommand(token);
    }

    @Override
    public abstract Object getCommand(TargetConfiguration var1, Object var2);

    public PageHolderFactory getPageHolderFactory() {
        return this.pageHolderFactory;
    }

    @Resource
    public void setPageHolderFactory(PageHolderFactory pageHolderFactory) {
        this.pageHolderFactory = pageHolderFactory;
    }

    public ApplicationContext getApplicationContext() {
        return this.ctx;
    }

    public void setApplicationContext(ApplicationContext ctx) {
        this.ctx = ctx;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.pageHolderFactory, (String)"pageHolderFactory must be initialized");
    }
}

