/*
 * Decompiled with CFR 0.152.
 */
package org.shept.org.springframework.web.servlet.mvc.delegation.command;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.shept.beans.support.ReloadableAssociation;
import org.shept.org.springframework.beans.support.Refreshable;
import org.shept.org.springframework.web.servlet.mvc.delegation.command.AbstractCommandFactory;
import org.shept.org.springframework.web.servlet.mvc.delegation.command.CommandFactory;
import org.shept.org.springframework.web.servlet.mvc.delegation.configuration.ChainConfigurationException;
import org.shept.org.springframework.web.servlet.mvc.delegation.configuration.TargetConfiguration;
import org.shept.org.springframework.web.servlet.mvc.support.ModelUtils;
import org.shept.persistence.ModelCreation;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class AssociationCommandFactory
extends AbstractCommandFactory
implements CommandFactory {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String relation;

    @Override
    public Object getCommand(TargetConfiguration config, Object model) {
        String assoc;
        if (model == null) {
            throw new ChainConfigurationException("Configuration error in '" + config.getChainNameDisplay() + "'. <Null> model is not allowed for associations");
        }
        String string = assoc = this.relation == null ? config.getTo().getBeanName() : this.relation;
        if (assoc != null && assoc.startsWith("get")) {
            assoc = this.relation.substring("get".length());
        }
        String methodGetter = "get" + StringUtils.capitalize((String)assoc);
        Method mth = ReflectionUtils.findMethod(model.getClass(), (String)methodGetter);
        if (mth == null) {
            return null;
        }
        Class rt = Object.class;
        if (null != mth) {
            rt = mth.getReturnType();
        }
        if (List.class.isAssignableFrom(rt)) {
            return this.createWrappedList(config, mth, model);
        }
        if (Collection.class.isAssignableFrom(rt)) {
            throw new ChainConfigurationException("Collection types other than 'List' are currently not supported. Type " + rt.getClass().toString() + " is not supported. Use List instead");
        }
        return this.createWrappedEntity(config, mth, model);
    }

    protected Object createWrappedEntity(TargetConfiguration config, Method mth, Object model) {
        Object target = ReflectionUtils.invokeMethod((Method)mth, (Object)model);
        Object command = ModelUtils.wrapIfNecessary(target);
        return command;
    }

    protected Object createWrappedList(TargetConfiguration config, Method mth, Object model) {
        ReloadableAssociation ass = this.createFilter(config, mth, model);
        Refreshable chainedPageHolder = this.getPageHolderFactory().getObject();
        chainedPageHolder.setFilter(ass);
        return chainedPageHolder;
    }

    protected ReloadableAssociation createFilter(TargetConfiguration cc, Method mth, Object model) {
        ReloadableAssociation ass = new ReloadableAssociation();
        ass.setAssociationMethod(mth);
        ass.setSourceModel(model);
        if (!cc.getDisabledActions().isCreate()) {
            ModelCreation mod = this.getNewModelTemplate(cc.getEntityClass(), model);
            ass.setNewModelTemplate(mod);
        }
        return ass;
    }

    public ModelCreation getNewModelTemplate(Class<?> clazz, Object model) {
        String initString = "???";
        return ModelUtils.getNewModelTemplate(clazz, model, initString);
    }

    public void setRelation(String relation) {
        this.relation = relation;
    }
}

