/*
 * Decompiled with CFR 0.152.
 */
package org.shept.org.springframework.web.servlet.mvc.delegation.command;

import java.lang.reflect.Method;
import org.shept.beans.support.FilterDefinition;
import org.shept.org.springframework.beans.support.Refreshable;
import org.shept.org.springframework.web.servlet.mvc.delegation.command.AbstractCommandFactory;
import org.shept.org.springframework.web.servlet.mvc.delegation.command.CommandFactory;
import org.shept.org.springframework.web.servlet.mvc.delegation.configuration.ChainConfigurationException;
import org.shept.org.springframework.web.servlet.mvc.delegation.configuration.TargetConfiguration;
import org.shept.org.springframework.web.servlet.mvc.support.ModelUtils;
import org.shept.persistence.provider.hibernate.HibernateCriteriaDefinition;
import org.shept.persistence.provider.hibernate.HibernateCriteriaFilter;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.ReflectionUtils;

public class RefreshableListCommandFactory
extends AbstractCommandFactory
implements CommandFactory,
InitializingBean {
    private FilterDefinition filter;

    @Override
    public Object getCommand(TargetConfiguration config, Object referencedModel) {
        Refreshable listHolder = this.getPageHolderFactory().getObject();
        FilterDefinition fil = this.filter;
        if (fil == null) {
            fil = this.createFilter(config);
        }
        this.initializeFilter(fil, config);
        ModelUtils.initialize(fil, referencedModel);
        listHolder.setFilter(fil);
        return listHolder;
    }

    protected void initializeFilter(FilterDefinition fil, TargetConfiguration config) {
        HibernateCriteriaFilter hcFilter;
        if (HibernateCriteriaFilter.class.isAssignableFrom(fil.getClass()) && (hcFilter = (HibernateCriteriaFilter)fil).getEntityClass() == null) {
            hcFilter.setEntityClass(config.getEntityClass());
        }
    }

    protected FilterDefinition createFilter(TargetConfiguration config) {
        Method mth;
        if (config.getFilterClass() == null) {
            throw new ChainConfigurationException("Filter Configuration error in '" + config.getChainNameDisplay() + "'. A filterClass must be specified");
        }
        if (HibernateCriteriaDefinition.class.isAssignableFrom(config.getFilterClass()) && config.getEntityClass() == null) {
            throw new ChainConfigurationException("Filter Configuration error in '" + config.getChainNameDisplay() + "'. An entityClass must be specified");
        }
        FilterDefinition filter = (FilterDefinition)BeanUtils.instantiate(config.getFilterClass());
        if (config.getFilterInitMethod() != null && (mth = ReflectionUtils.findMethod(filter.getClass(), (String)config.getFilterInitMethod())) != null) {
            try {
                mth.invoke((Object)filter, new Object[0]);
            }
            catch (Exception ex) {
                throw new ChainConfigurationException("Filter Configuration error in '" + config.getChainNameDisplay() + "'. Filter initialization with '" + config.getFilterInitMethod() + "' threw Exception", ex);
            }
        }
        return filter;
    }

    public void setFilter(FilterDefinition filter) {
        this.filter = filter;
    }
}

