/*
 * Decompiled with CFR 0.152.
 */
package org.shept.org.springframework.web.servlet.mvc.delegation.component;

import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.shept.org.springframework.web.servlet.mvc.delegation.ComponentToken;
import org.shept.org.springframework.web.servlet.mvc.delegation.ComponentUtils;
import org.shept.org.springframework.web.servlet.mvc.delegation.SubCommandProvider;
import org.shept.org.springframework.web.servlet.mvc.delegation.component.WebComponent;
import org.shept.util.ResourceInitializer;
import org.springframework.beans.BeansException;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.DataBinder;
import org.springframework.validation.FieldError;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.support.WebContentGenerator;
import org.springframework.web.servlet.view.RedirectView;

public abstract class AbstractComponent
extends WebContentGenerator
implements WebComponent {
    public static String ANCHOR_PREFIX = "#a";
    private String anchorPrefix = ANCHOR_PREFIX;
    private Map<String, String> mappings = this.getDefaultMappings();
    private boolean copyResources = true;
    private ResourceInitializer[] resources;

    protected ModelAndView modelWithErrors(DataBinder binder) {
        ModelAndView mav = new ModelAndView();
        mav.addAllObjects(binder.getBindingResult().getModel());
        return mav;
    }

    protected ModelAndView modelRedirect(HttpServletRequest request, ComponentToken token, Integer index) {
        int idx = 0;
        idx = index != null && index < 0 ? ComponentUtils.lookupComponentIndex(token) : ComponentUtils.removeComponentsAfterIndex(token, index);
        String jump = "";
        if (idx > 0) {
            int lastIdx = ((SubCommandProvider)token.getCommand()).getChildren().size() - 1;
            idx = Math.min(idx, lastIdx);
            jump = this.getAnchorPrefix() + String.valueOf(idx);
            return new ModelAndView((View)new RedirectView(jump, true));
        }
        return new ModelAndView((View)new RedirectView());
    }

    protected ModelAndView modelRedirectClip(HttpServletRequest request, ComponentToken token) {
        return this.modelRedirect(request, token, null);
    }

    protected ModelAndView modelRedirect(HttpServletRequest request, ComponentToken token) {
        return this.modelRedirect(request, token, -1);
    }

    protected ModelAndView modelUnhandled(HttpServletRequest request, ComponentToken token) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error((Object)("The active handler " + this.getClass() + " could not handle command token " + token.toString()));
        }
        return new ModelAndView((View)new RedirectView());
    }

    public abstract Map<String, String> getDefaultMappings();

    @Override
    public boolean supportsAction(ComponentToken token) {
        return CollectionUtils.arrayToList((Object)this.supportedActions()).contains(token.getToken().getMethod());
    }

    @Override
    public String[] supportedActions() {
        return this.getMappings().values().toArray(new String[0]);
    }

    @Override
    public Map<String, String> getMappings() {
        return this.mappings;
    }

    public void setMappings(Map<String, String> mappings) {
        this.mappings = mappings;
    }

    protected boolean hasErrorsInPath(BindingResult errors, ComponentToken token, String suffix) {
        String tokenPath = token.getToken().getPathName();
        if (tokenPath.endsWith(".")) {
            tokenPath = tokenPath.substring(0, tokenPath.lastIndexOf("."));
        }
        if (StringUtils.hasText((String)suffix)) {
            tokenPath = tokenPath + "." + suffix;
        }
        List err = errors.getFieldErrors();
        for (FieldError fe : err) {
            if (!fe.getField().startsWith(tokenPath)) continue;
            return true;
        }
        return false;
    }

    public String getAnchorPrefix() {
        return this.anchorPrefix;
    }

    public void setAnchorPrefix(String anchorPrefix) {
        this.anchorPrefix = anchorPrefix;
    }

    protected void initApplicationContext() throws BeansException {
        super.initApplicationContext();
        if (this.isCopyResources() && this.resources != null) {
            for (int i = 0; i < this.resources.length; ++i) {
                this.resources[i].initializeResources(this.getServletContext());
            }
        }
    }

    public boolean isCopyResources() {
        return this.copyResources;
    }

    public void setCopyResources(boolean copyResources) {
        this.copyResources = copyResources;
    }

    public ResourceInitializer[] getResources() {
        return this.resources;
    }

    public void setResources(ResourceInitializer[] resources) {
        this.resources = resources;
    }
}

