/*
 * Decompiled with CFR 0.152.
 */
package org.shept.org.springframework.web.servlet.mvc.delegation.component;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.shept.org.springframework.web.bind.support.ComponentDataBinder;
import org.shept.org.springframework.web.servlet.mvc.delegation.ComponentToken;
import org.shept.org.springframework.web.servlet.mvc.delegation.ComponentUtils;
import org.shept.org.springframework.web.servlet.mvc.delegation.component.AbstractPersistenceComponent;
import org.shept.org.springframework.web.servlet.mvc.delegation.configuration.SegmentConfiguration;
import org.springframework.validation.Validator;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.servlet.ModelAndView;

public abstract class AbstractEditingComponent
extends AbstractPersistenceComponent {
    private Validator[] validators;

    @Override
    protected ModelAndView doActionInternal(HttpServletRequest request, ComponentToken token) throws Exception {
        String method = token.getToken().getMethod();
        if (method.equals("onCancel")) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Cancelled request: " + token.toString()));
            }
            return this.doCancel(request, token);
        }
        if (method.equals("onSave")) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Save request " + (this.enableSave ? "" : "BLOCKED") + ": " + token.toString()));
            }
            if (this.enableSave) {
                ComponentDataBinder binder = token.getBinder();
                binder.bindAndValidate(new ServletWebRequest(request), token);
                this.onBindAndValidate(request, token);
                if (this.hasErrorsInPath(binder.getBindingResult(), token, "") || binder.getBindingResult().getGlobalErrorCount() > 0) {
                    ModelAndView mav = new ModelAndView();
                    mav.addAllObjects(binder.getBindingResult().getModel());
                    return mav;
                }
                return this.doSave(request, token);
            }
            return this.modelRedirectClip(request, token);
        }
        if (method.equals("onDelete")) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Delete request " + (this.enableDelete ? "" : "BLOCKED") + ": " + token.toString()));
            }
            if (this.enableDelete) {
                return this.doDelete(request, token);
            }
            return this.modelRedirectClip(request, token);
        }
        return this.modelUnhandled(request, token);
    }

    protected void onBindAndValidate(HttpServletRequest request, ComponentToken token) throws Exception {
    }

    protected abstract ModelAndView doCancel(HttpServletRequest var1, ComponentToken var2) throws Exception;

    protected abstract ModelAndView doSave(HttpServletRequest var1, ComponentToken var2) throws Exception;

    protected abstract ModelAndView doDelete(HttpServletRequest var1, ComponentToken var2) throws Exception;

    protected String getCustomSaveTransaction(HttpServletRequest request, ComponentToken token) {
        SegmentConfiguration config = ComponentUtils.getConfiguration(request, token);
        if (config != null && config.getTransaction() != null) {
            return config.getTransaction().getSave();
        }
        return null;
    }

    protected String getCustomDeleteTransaction(HttpServletRequest request, ComponentToken token) {
        SegmentConfiguration config = ComponentUtils.getConfiguration(request, token);
        if (config != null && config.getTransaction() != null) {
            return config.getTransaction().getDelete();
        }
        return null;
    }

    @Override
    public Map<String, String> getDefaultMappings() {
        HashMap<String, String> mappings = new HashMap<String, String>();
        mappings.put("submitCancel", "onCancel");
        mappings.put("submitSave", "onSave");
        mappings.put("submitDelete", "onDelete");
        return mappings;
    }

    public Validator[] getValidators() {
        return this.validators;
    }

    public void setValidators(Validator[] validators) {
        this.validators = validators;
    }
}

