/*
 * Decompiled with CFR 0.152.
 */
package org.shept.org.springframework.web.servlet.mvc.delegation.component;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.shept.org.springframework.web.bind.support.ComponentDataBinder;
import org.shept.org.springframework.web.servlet.mvc.delegation.ComponentToken;
import org.shept.org.springframework.web.servlet.mvc.delegation.component.AbstractComponent;
import org.shept.org.springframework.web.servlet.mvc.delegation.component.WebComponent;
import org.shept.org.springframework.web.servlet.mvc.support.ModelUtils;
import org.shept.persistence.ModelCreation;
import org.shept.persistence.ModelDeletion;
import org.shept.persistence.UnsupportedModelTransformation;
import org.shept.persistence.provider.DaoUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.NestedRuntimeException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.support.DaoSupport;
import org.springframework.orm.ObjectOptimisticLockingFailureException;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;
import org.springframework.orm.jpa.support.JpaDaoSupport;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.util.Assert;
import org.springframework.validation.DataBinder;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

public abstract class AbstractPersistenceComponent
extends AbstractComponent
implements InitializingBean,
WebComponent {
    public static final String OPTIMISTIC_LOCKING_ERROR = "dataAccess.optimisticLockingError";
    public static final String DATA_INTEGRITY_ERROR = "dataAccess.integrityError";
    public static final String DATA_ACCESS_ERROR = "dataAccess.error";
    protected boolean enableSave = true;
    protected boolean enableDelete = true;
    protected boolean reloadOnCancel = true;
    protected boolean enableDaoTransactions = true;
    protected PlatformTransactionManager transactionManager = null;
    protected DaoSupport dao;

    @Override
    public ModelAndView excecuteAction(HttpServletRequest request, HttpServletResponse response, ComponentToken token) throws Exception {
        ModelAndView mav;
        block8: {
            ComponentDataBinder binder = token.getBinder();
            mav = new ModelAndView((View)new RedirectView());
            try {
                mav = this.doActionInternal(request, token);
            }
            catch (ObjectOptimisticLockingFailureException ex) {
                binder.getBindingResult().reject(OPTIMISTIC_LOCKING_ERROR, "Concurrency error: Record already changed by another user. Abort operation and try again");
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)"Concurrency Error in persistence operation", (Throwable)ex);
                }
                return this.modelWithErrors((DataBinder)binder);
            }
            catch (DataIntegrityViolationException ex) {
                binder.getBindingResult().reject(DATA_INTEGRITY_ERROR, "Data Integrity Violation: Dataset contains forbidden NULLs or duplicate records or deletion fails due to orphaned references");
                if (this.logger.isErrorEnabled()) {
                    this.logger.error((Object)"Data Integrity violation error", (Throwable)ex);
                }
                return this.modelWithErrors((DataBinder)binder);
            }
            catch (DataAccessException ex) {
                binder.getBindingResult().reject(DATA_ACCESS_ERROR, "Unrecoverable data access layer error. See service log file for details");
                if (this.logger.isErrorEnabled()) {
                    this.logger.error((Object)"Data access layer error", (Throwable)ex);
                }
                return this.modelWithErrors((DataBinder)binder);
            }
            catch (NestedRuntimeException ue) {
                if (!this.logger.isErrorEnabled()) break block8;
                this.logger.error((Object)"Nested Runtime Exception ", (Throwable)ue);
            }
        }
        return mav;
    }

    protected abstract ModelAndView doActionInternal(HttpServletRequest var1, ComponentToken var2) throws Exception;

    protected void doInTransactionIfAvailable(TransactionCallback<Object> transactionCallback) throws Exception {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setName(AbstractPersistenceComponent.class.getName());
        def.setPropagationBehavior(0);
        if (this.transactionManager != null) {
            TransactionStatus status = this.transactionManager.getTransaction((TransactionDefinition)def);
            try {
                transactionCallback.doInTransaction(status);
            }
            catch (Exception ex) {
                this.transactionManager.rollback(status);
                throw ex;
            }
            this.transactionManager.commit(status);
        } else {
            transactionCallback.doInTransaction(null);
            this.doFlushSession();
        }
    }

    protected void doSaveModel(Object modelObject) {
        this.doSaveModel(modelObject, null);
    }

    protected void doSaveModel(Object rowObject, ModelCreation modelCreation) {
        Object saveModel = this.getWrappedModel(rowObject);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Saving model " + saveModel.toString()));
        }
        if (this.dao instanceof HibernateDaoSupport) {
            HibernateDaoSupport hibernateDao = (HibernateDaoSupport)this.dao;
            boolean newModel = DaoUtils.isNewModel((DaoSupport)hibernateDao, saveModel);
            if (newModel) {
                if (modelCreation == null || modelCreation.isCreationAllowed(saveModel)) {
                    hibernateDao.getHibernateTemplate().save(saveModel);
                }
            } else {
                hibernateDao.getHibernateTemplate().saveOrUpdate(saveModel);
            }
        } else if (this.dao instanceof JpaDaoSupport) {
            JpaDaoSupport jpaDao = (JpaDaoSupport)this.dao;
            jpaDao.getJpaTemplate().persist(saveModel);
        }
    }

    protected void doFlushSession() {
        if (this.dao instanceof HibernateDaoSupport) {
            HibernateDaoSupport hibernateDao = (HibernateDaoSupport)this.dao;
            hibernateDao.getHibernateTemplate().flush();
        } else if (this.dao instanceof JpaDaoSupport) {
            JpaDaoSupport jpaDao = (JpaDaoSupport)this.dao;
            jpaDao.getJpaTemplate().flush();
        }
    }

    protected boolean doDeleteModel(Object rowObject) {
        boolean delFlag;
        Object model = this.getWrappedModel(rowObject);
        if (model instanceof ModelDeletion && (delFlag = ((ModelDeletion)model).setDeleted(true))) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Deleting model by special case deletion handling (set deletion flag)" + this.toString()));
            }
            this.doSaveModel(model, null);
            return false;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Deleting model " + model.toString()));
        }
        if (this.dao instanceof HibernateDaoSupport) {
            HibernateDaoSupport hibernateDao = (HibernateDaoSupport)this.dao;
            hibernateDao.getHibernateTemplate().delete(model);
        } else if (this.dao instanceof JpaDaoSupport) {
            JpaDaoSupport jpaDao = (JpaDaoSupport)this.dao;
            jpaDao.getJpaTemplate().remove(model);
        }
        return true;
    }

    protected Object getWrappedModel(Object model) throws UnsupportedModelTransformation {
        Object rv = ModelUtils.unwrapIfNecessary(model);
        if (rv.getClass().isArray() || rv instanceof Map || rv instanceof List || rv instanceof Set) {
            throw new UnsupportedModelTransformation(model);
        }
        return rv;
    }

    public DaoSupport getDao() {
        return this.dao;
    }

    @Resource
    public void setDao(DaoSupport dao) {
        this.dao = dao;
    }

    public void setEnableSave(boolean enableSave) {
        this.enableSave = enableSave;
    }

    public void setEnableDelete(boolean enableDelete) {
        this.enableDelete = enableDelete;
    }

    @Resource
    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.dao, (String)"A Hibernate or Jpa persistence wrapper must be specified");
        Assert.isTrue((this.dao instanceof HibernateDaoSupport || this.dao instanceof JpaDaoSupport ? 1 : 0) != 0, (String)("Only Jpa or Hibernate persistence wrappers are supported, " + this.dao.getClass().toString() + " is unsupported."));
    }

    public void setReloadOnCancel(boolean reloadOnCancel) {
        this.reloadOnCancel = reloadOnCancel;
    }

    public boolean isEnableSave() {
        return this.enableSave;
    }

    public boolean isEnableDelete() {
        return this.enableDelete;
    }

    public boolean isReloadOnCancel() {
        return this.reloadOnCancel;
    }

    public boolean isEnableDaoTransactions() {
        return this.enableDaoTransactions;
    }

    public void setEnableDaoTransactions(boolean enableDaoTransactions) {
        this.enableDaoTransactions = enableDaoTransactions;
    }
}

