/*
 * Decompiled with CFR 0.152.
 */
package org.shept.org.springframework.web.servlet.mvc.delegation.component;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.persistence.Entity;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.shept.org.springframework.beans.support.CommandWrapper;
import org.shept.org.springframework.beans.support.ModelSupplier;
import org.shept.org.springframework.beans.support.PageableList;
import org.shept.org.springframework.beans.support.Refreshable;
import org.shept.org.springframework.web.servlet.mvc.delegation.ComponentToken;
import org.shept.org.springframework.web.servlet.mvc.delegation.ComponentUtils;
import org.shept.org.springframework.web.servlet.mvc.delegation.command.CommandFactory;
import org.shept.org.springframework.web.servlet.mvc.delegation.component.AbstractComponent;
import org.shept.org.springframework.web.servlet.mvc.delegation.component.DefaultProperties;
import org.shept.org.springframework.web.servlet.mvc.delegation.configuration.ChainConfigurationException;
import org.shept.org.springframework.web.servlet.mvc.delegation.configuration.TargetConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.dao.support.DaoSupport;
import org.springframework.util.StringUtils;
import org.springframework.validation.DataBinder;
import org.springframework.web.servlet.ModelAndView;

public class ChainingComponent
extends AbstractComponent {
    protected boolean enableChain = true;
    protected boolean enableInfo = true;
    protected DaoSupport dao;

    @Override
    public ModelAndView excecuteAction(HttpServletRequest request, HttpServletResponse response, ComponentToken token) throws Exception {
        String method = token.getToken().getMethod();
        if (method.equals("onChain")) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Chain request " + (this.enableChain ? "" : "BLOCKED") + ": " + token.toString()));
            }
            if (this.enableChain) {
                return this.doChain(request, token);
            }
            return this.modelRedirectClip(request, token);
        }
        return this.modelUnhandled(request, token);
    }

    protected ModelAndView doChain(HttpServletRequest request, ComponentToken token) {
        String info;
        Object model = ComponentUtils.getModel(token);
        TargetConfiguration cc = ComponentUtils.getChainConfiguration(request, token);
        if (cc == null) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error((Object)ComponentUtils.getChainConfigurationErrorMessage(request, token));
            }
            return this.modelRedirectClip(request, token);
        }
        CommandFactory cf = cc.getCommandFactory();
        if (cf == null) {
            this.logger.error((Object)("No CommandFactory configured for chain '" + cc.getChainNameDisplay() + "'"));
            return this.modelRedirectClip(request, token);
        }
        Object cmd = null;
        try {
            cmd = cf.getCommand(request, token);
        }
        catch (ChainConfigurationException ex) {
            this.logger.error((Object)"Runtime error during chain processing ", (Throwable)((Object)ex));
        }
        if (cmd == null) {
            return this.modelWithErrors((DataBinder)token.getBinder());
        }
        CommandWrapper cw = new CommandWrapper();
        if (cmd instanceof CommandWrapper) {
            cw = (CommandWrapper)cmd;
        } else {
            cw.setTagName(cc.getTo().getBeanName());
            cw.setCommand(cmd);
        }
        ComponentUtils.applyConfiguration(cw, (ApplicationContext)this.getWebApplicationContext());
        if (cw.getCommand() instanceof Refreshable) {
            Refreshable content = (Refreshable)cw.getCommand();
            try {
                content.refresh();
            }
            catch (Exception ex) {
                this.logger.error((Object)("Error while loading content for component '" + cw.getTagName() + "'"), (Throwable)ex);
            }
        }
        if (this.enableInfo && StringUtils.hasText((String)(info = ComponentUtils.getComponentInfo(request, cc.getInfo(), model)))) {
            cw.getProperties().put(DefaultProperties.INFO, info);
        }
        int idx = ComponentUtils.addComponent(token, cw);
        return this.modelRedirect(request, token, idx);
    }

    protected void initComponentCommandWrapper(CommandWrapper cw) {
        ComponentUtils.applyConfiguration(cw, (ApplicationContext)this.getWebApplicationContext());
    }

    @Override
    public boolean supports(Object commandObject) {
        return true;
    }

    public boolean supports_oldVersion(Object commandObject) {
        Class<?> clazz = commandObject.getClass();
        Entity ann = (Entity)AnnotationUtils.findAnnotation(clazz, Entity.class);
        boolean isPl = PageableList.class.isAssignableFrom(clazz);
        boolean isMw = ModelSupplier.class.isAssignableFrom(clazz);
        boolean isEntity = ann != null;
        return isPl || isMw || isEntity;
    }

    @Override
    public Map<String, String> getDefaultMappings() {
        HashMap<String, String> mappings = new HashMap<String, String>();
        mappings.put("submitChain", "onChain");
        return mappings;
    }

    public void setEnableInfo(boolean enableInfo) {
        this.enableInfo = enableInfo;
    }

    @Resource
    public void setDao(DaoSupport dao) {
        this.dao = dao;
    }

    public DaoSupport getDao() {
        return this.dao;
    }
}

