/*
 * Decompiled with CFR 0.152.
 */
package org.shept.org.springframework.web.servlet.mvc.delegation.component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.shept.org.springframework.beans.support.FilterType;
import org.shept.org.springframework.beans.support.PageableList;
import org.shept.org.springframework.beans.support.Refreshable;
import org.shept.org.springframework.web.bind.support.ComponentDataBinder;
import org.shept.org.springframework.web.servlet.mvc.delegation.ComponentToken;
import org.shept.org.springframework.web.servlet.mvc.delegation.component.AbstractComponent;
import org.shept.org.springframework.web.servlet.mvc.delegation.component.WebComponent;
import org.springframework.validation.DataBinder;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.servlet.ModelAndView;

public class FilteredListComponent
extends AbstractComponent
implements WebComponent {
    protected int newModelSize = 1;

    @Override
    public ModelAndView excecuteAction(HttpServletRequest request, HttpServletResponse response, ComponentToken token) throws Exception {
        return this.doActionInternal(request, token);
    }

    protected ModelAndView doActionInternal(HttpServletRequest request, ComponentToken token) throws Exception {
        String method = token.getToken().getMethod();
        Refreshable filter = (Refreshable)token.getComponent();
        PageableList pagedList = (PageableList)token.getComponent();
        ComponentDataBinder binder = token.getBinder();
        if (method.equals("onFilterCancel")) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Cancel filter operation: " + token.toString()));
            }
            binder.bindAndValidate(new ServletWebRequest(request), token);
            if (this.hasErrorsInPath(binder.getBindingResult(), token, "filter")) {
                filter.setUseFilter(FilterType.FILTER_LAST_USED);
            } else {
                filter.setUseFilter(FilterType.FILTER_INITIAL);
            }
            pagedList.setPage(0);
            filter.refresh();
            return this.modelRedirectClip(request, token);
        }
        if (method.equals("onFilter")) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Excecute filter: " + token.toString()));
            }
            binder.bindAndValidate(new ServletWebRequest(request), token);
            if (this.hasErrorsInPath(binder.getBindingResult(), token, "filter")) {
                return this.modelWithErrors((DataBinder)binder);
            }
            pagedList.setPage(0);
            filter.refresh();
            return this.modelRedirectClip(request, token);
        }
        if (method.equals("onAddTransient")) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Add transient model(s): " + token.toString()));
            }
            int savedSize = pagedList.getNewModelSize();
            pagedList.setNewModelSize(this.newModelSize);
            List src = pagedList.getSource();
            pagedList.setSource(src);
            pagedList.setPage(0);
            pagedList.setNewModelSize(savedSize);
            return this.modelRedirectClip(request, token);
        }
        return this.modelUnhandled(request, token);
    }

    @Override
    public Map<String, String> getDefaultMappings() {
        HashMap<String, String> mappings = new HashMap<String, String>();
        mappings.put("submitFilter", "onFilter");
        mappings.put("submitFilterReset", "onFilterCancel");
        mappings.put("submitAddTransient", "onAddTransient");
        return mappings;
    }

    @Override
    public boolean supports(Object commandObject) {
        return commandObject instanceof PageableList && commandObject instanceof Refreshable;
    }

    public int getNewModelSize() {
        return this.newModelSize;
    }

    public void setNewModelSize(int newModelSize) {
        this.newModelSize = newModelSize;
    }
}

