/*
 * Decompiled with CFR 0.152.
 */
package org.shept.org.springframework.web.servlet.mvc.delegation.component;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.shept.org.springframework.web.servlet.mvc.delegation.ComponentToken;
import org.shept.org.springframework.web.servlet.mvc.delegation.ComponentUtils;
import org.shept.org.springframework.web.servlet.mvc.delegation.component.AbstractComponent;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.servlet.ModelAndView;

public class FormControlComponent
extends AbstractComponent {
    @Override
    public ModelAndView excecuteAction(HttpServletRequest request, HttpServletResponse response, ComponentToken token) throws Exception {
        String method = token.getToken().getMethod();
        if (method.equals("onClose")) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Close the current and all subsequent subforms: " + token.toString()));
            }
            int idx = ComponentUtils.lookupComponentIndex(token);
            return this.modelRedirect(request, token, idx - 1);
        }
        if (method.equals("onRefresh")) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Do a refresh with token: " + token.toString()));
            }
            token.getBinder().bindAndValidate(new ServletWebRequest(request), token);
            return this.modelRedirectClip(request, token);
        }
        return this.modelUnhandled(request, token);
    }

    @Override
    public Map<String, String> getDefaultMappings() {
        HashMap<String, String> mappings = new HashMap<String, String>();
        mappings.put("submitClose", "onClose");
        mappings.put("submitRefresh", "onRefresh");
        return mappings;
    }

    @Override
    public boolean supports(Object commandObject) {
        return true;
    }
}

