/*
 * Decompiled with CFR 0.152.
 */
package org.shept.org.springframework.web.servlet.mvc.delegation.component;

import java.lang.reflect.Method;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.shept.beans.support.FilterDefinition;
import org.shept.org.springframework.beans.support.PageableList;
import org.shept.org.springframework.beans.support.Refreshable;
import org.shept.org.springframework.web.servlet.mvc.delegation.ComponentToken;
import org.shept.org.springframework.web.servlet.mvc.delegation.component.AbstractEditingComponent;
import org.shept.org.springframework.web.servlet.mvc.support.RequestValueUtils;
import org.shept.persistence.ModelCreation;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.ModelAndView;

public class ListPersistenceComponent
extends AbstractEditingComponent {
    @Override
    protected ModelAndView doCancel(HttpServletRequest request, ComponentToken token) throws Exception {
        boolean reload = this.isReloadOnCancel();
        PageableList pagedList = (PageableList)token.getComponent();
        Refreshable filter = null;
        if (token.getComponent() instanceof Refreshable) {
            filter = (Refreshable)token.getComponent();
        } else {
            reload = false;
        }
        if (reload) {
            Integer loadSize = Math.max(filter.getSourceProvider().getLoadSize(), pagedList.getLastElementOnPage() + 1);
            filter.getSourceProvider().setLoadSize(loadSize);
            filter.refresh();
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)"When we can't ask the provider (filter) to deliver the collection again then we need to keep a deepCopy of the collection before making any changes.This is quite an expensive operation and can't be recommended as we would have to do it just in case it might be needed later. So we go on with the modified collection here");
        }
        return this.modelRedirectClip(request, token);
    }

    @Override
    protected ModelAndView doSave(HttpServletRequest request, ComponentToken token) throws Exception {
        PageableList pagedList = (PageableList)token.getComponent();
        if (pagedList.getFirstElementOnPage() < 0 || pagedList.getFirstElementOnPage() >= pagedList.getNrOfElements()) {
            return this.modelRedirectClip(request, token);
        }
        String saveTransaction = this.getCustomSaveTransaction(request, token);
        if (StringUtils.hasText((String)saveTransaction)) {
            this.doCustomTransaction(saveTransaction, pagedList, null);
            return this.modelRedirectClip(request, token);
        }
        this.doSaveList(request, pagedList);
        return this.modelRedirectClip(request, token);
    }

    @Override
    protected ModelAndView doDelete(HttpServletRequest request, ComponentToken token) throws Exception {
        int idx;
        PageableList pagedList = (PageableList)token.getComponent();
        if (!pagedList.isVisible(idx = RequestValueUtils.getIndexParameter(token.getToken().getValue()))) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error((Object)("Invalid or Missing Integer Row-number argument value for action " + token.toString()));
            }
            return this.modelRedirectClip(request, token);
        }
        String deleteTransaction = this.getCustomDeleteTransaction(request, token);
        if (StringUtils.hasText((String)deleteTransaction)) {
            this.doCustomTransaction(deleteTransaction, pagedList, idx);
            return this.modelRedirectClip(request, token);
        }
        this.doDelete(request, pagedList, idx);
        return this.modelRedirectClip(request, token);
    }

    protected void doCustomTransaction(String transaction, PageableList<?> pagedList, Integer idx) throws Exception {
        Method mth = ReflectionUtils.findMethod(this.getDao().getClass(), (String)transaction, (Class[])new Class[]{pagedList.getClass()});
        if (mth != null) {
            this.executeTransaction(mth, pagedList, idx);
            return;
        }
        mth = ReflectionUtils.findMethod(this.getDao().getClass(), (String)transaction, (Class[])new Class[]{PageableList.class});
        if (mth != null) {
            this.executeTransaction(mth, pagedList, idx);
            return;
        }
        mth = ReflectionUtils.findMethod(this.getDao().getClass(), (String)transaction, (Class[])new Class[]{List.class});
        if (mth != null) {
            this.executeTransaction(mth, pagedList.getPageList(), idx);
            return;
        }
        if (this.logger.isErrorEnabled()) {
            this.logger.error((Object)("The transaction " + transaction + " with a '" + pagedList.getClass() + "'-parameter could not be found in the class " + this.getDao().getClass()));
        }
    }

    private void executeTransaction(final Method mth, final Object target, final Integer idx) throws Exception {
        this.doInTransactionIfAvailable(new TransactionCallback<Object>(){

            public Object doInTransaction(TransactionStatus status) {
                if (idx == null) {
                    ReflectionUtils.invokeMethod((Method)mth, (Object)ListPersistenceComponent.this.getDao(), (Object[])new Object[]{target});
                } else {
                    ReflectionUtils.invokeMethod((Method)mth, (Object)ListPersistenceComponent.this.getDao(), (Object[])new Object[]{target, idx});
                }
                return null;
            }
        });
    }

    protected void doSaveList(HttpServletRequest request, final PageableList<?> listHolder) throws Exception {
        this.doInTransactionIfAvailable(new TransactionCallback<Object>(){
            final ModelCreation mc;
            {
                this.mc = ListPersistenceComponent.this.getModelCreation(listHolder);
            }

            public Object doInTransaction(TransactionStatus status) {
                for (int i = listHolder.getFirstElementOnPage(); i <= listHolder.getLastElementOnPage(); ++i) {
                    ListPersistenceComponent.this.doSaveModel(listHolder.getSource().get(i), this.mc);
                }
                return null;
            }
        });
    }

    protected void doDelete(HttpServletRequest request, final PageableList<?> listHolder, final int idx) throws Exception {
        this.doInTransactionIfAvailable(new TransactionCallback<Object>(){

            public Object doInTransaction(TransactionStatus status) {
                boolean delFlag = ListPersistenceComponent.this.doDeleteModel(listHolder.getSource().get(idx));
                if (delFlag) {
                    listHolder.getSource().remove(idx);
                }
                return null;
            }
        });
    }

    protected ModelCreation getModelCreation(PageableList<?> listHolder) {
        ModelCreation model = null;
        if (listHolder instanceof Refreshable) {
            FilterDefinition filter = ((Refreshable)((Object)listHolder)).getFilter();
            model = filter.getNewModelTemplate();
        }
        if (model == null && listHolder.getNewModelTemplate() instanceof ModelCreation) {
            model = (ModelCreation)listHolder.getNewModelTemplate();
        }
        return model;
    }

    @Override
    public boolean supports(Object commandObject) {
        return commandObject instanceof PageableList;
    }
}

