/*
 * Decompiled with CFR 0.152.
 */
package org.shept.org.springframework.web.servlet.mvc.delegation.component;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.shept.org.springframework.web.servlet.mvc.delegation.ComponentToken;
import org.shept.org.springframework.web.servlet.mvc.delegation.component.AbstractComponent;
import org.shept.org.springframework.web.servlet.mvc.formcache.SessionFormCache;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

public class LoginComponent
extends AbstractComponent {
    private SessionFormCache formCache;
    private boolean clearFormCacheOnLogin = true;

    @Override
    public ModelAndView excecuteAction(HttpServletRequest request, HttpServletResponse response, ComponentToken token) throws Exception {
        String method = token.getToken().getMethod();
        if (method.equals("onLogin")) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Login with token: " + token.toString()));
            }
            HashMap<String, String> parms = new HashMap<String, String>();
            String usr = "j_username";
            String pwd = "j_password";
            parms.put(usr, ServletRequestUtils.getStringParameter((ServletRequest)request, (String)usr, (String)""));
            parms.put(pwd, ServletRequestUtils.getStringParameter((ServletRequest)request, (String)pwd, (String)""));
            if (this.getFormCache() != null && this.isClearFormCacheOnLogin()) {
                this.getFormCache().clearCache(request);
            }
            return new ModelAndView((View)new RedirectView("j_spring_security_check"), parms);
        }
        return this.modelUnhandled(request, token);
    }

    @Override
    public Map<String, String> getDefaultMappings() {
        HashMap<String, String> mappings = new HashMap<String, String>();
        mappings.put("submitLogin", "onLogin");
        return mappings;
    }

    @Override
    public boolean supports(Object commandObject) {
        return true;
    }

    public SessionFormCache getFormCache() {
        return this.formCache;
    }

    public void setFormCache(SessionFormCache formCache) {
        this.formCache = formCache;
    }

    public boolean isClearFormCacheOnLogin() {
        return this.clearFormCacheOnLogin;
    }

    public void setClearFormCacheOnLogin(boolean clearFormCacheOnLogin) {
        this.clearFormCacheOnLogin = clearFormCacheOnLogin;
    }
}

