/*
 * Decompiled with CFR 0.152.
 */
package org.shept.org.springframework.web.servlet.mvc.delegation.component;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.shept.org.springframework.beans.support.PageableList;
import org.shept.org.springframework.web.servlet.mvc.delegation.ComponentToken;
import org.shept.org.springframework.web.servlet.mvc.delegation.component.AbstractComponent;
import org.shept.org.springframework.web.servlet.mvc.delegation.component.WebComponent;
import org.springframework.beans.support.MutableSortDefinition;
import org.springframework.beans.support.SortDefinition;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.servlet.ModelAndView;

public class PagedListComponent
extends AbstractComponent
implements WebComponent {
    @Override
    public ModelAndView excecuteAction(HttpServletRequest request, HttpServletResponse response, ComponentToken token) throws Exception {
        return this.doActionInternal(request, token);
    }

    protected ModelAndView doActionInternal(HttpServletRequest request, ComponentToken token) throws Exception {
        String method = token.getToken().getMethod();
        PageableList pagedList = (PageableList)token.getComponent();
        if (method.equals("onGotoFirst")) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Jump to first page: " + token.toString()));
            }
            pagedList.setPage(0);
            return this.modelRedirect(request, token);
        }
        if (method.equals("onGotoNext")) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Jump to next page: " + token.toString()));
            }
            pagedList.setPage(Math.min(pagedList.getPage() + 1, pagedList.getPageCount() - 1));
            return this.modelRedirect(request, token);
        }
        if (method.equals("onGotoPrevious")) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Jump to previous page: " + token.toString()));
            }
            pagedList.setPage(Math.max(pagedList.getPage() - 1, 0));
            return this.modelRedirect(request, token);
        }
        if (method.equals("onGotoLast")) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Jump big step towards last page: " + token.toString()));
            }
            pagedList.setPage(pagedList.getPageCount() - 1);
            return this.modelRedirect(request, token);
        }
        if (method.equals("onGotoPage")) {
            int idx = 0;
            try {
                idx = Integer.parseInt(token.getToken().getValue());
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Jump to page " + idx + ": " + token.toString()));
            }
            pagedList.setPage(idx);
            return this.modelRedirect(request, token);
        }
        if (method.equals("onPageResize")) {
            int newSize;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Resize page: " + token.toString()));
            }
            if ((newSize = ServletRequestUtils.getIntParameter((ServletRequest)request, (String)(token.getToken().getPathName() + "pageSize"), (int)0)) > 0) {
                pagedList.setPageSize(newSize);
            }
            return this.modelRedirect(request, token);
        }
        if (method.equals("onSortAsc")) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Sort ascending: " + token.toString()));
            }
            this.resort(pagedList, token.getToken().getValue(), true);
            return this.modelRedirect(request, token);
        }
        if (method.equals("onSortDesc")) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Sort descending: " + token.toString()));
            }
            this.resort(pagedList, token.getToken().getValue(), false);
            return this.modelRedirect(request, token);
        }
        return this.modelUnhandled(request, token);
    }

    private void resort(PageableList<?> pagedList, String columnName, boolean asc) {
        MutableSortDefinition msd = new MutableSortDefinition();
        msd.setProperty(columnName);
        msd.setAscending(asc);
        pagedList.setSort((SortDefinition)msd);
        pagedList.resort();
    }

    @Override
    public Map<String, String> getDefaultMappings() {
        HashMap<String, String> mappings = new HashMap<String, String>();
        mappings.put("pageFirst", "onGotoFirst");
        mappings.put("pageNext", "onGotoNext");
        mappings.put("pagePrevious", "onGotoPrevious");
        mappings.put("pageLast", "onGotoLast");
        mappings.put("pageSelect", "onGotoPage");
        mappings.put("pageSortAsc", "onSortAsc");
        mappings.put("pageSortDesc", "onSortDesc");
        mappings.put("pageResize", "onPageResize");
        return mappings;
    }

    @Override
    public boolean supports(Object commandObject) {
        return commandObject instanceof PageableList;
    }
}

