/*
 * Decompiled with CFR 0.152.
 */
package org.shept.org.springframework.web.servlet.mvc.delegation.component;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.shept.org.springframework.beans.support.CommandWrapper;
import org.shept.org.springframework.web.servlet.mvc.delegation.ComponentToken;
import org.shept.org.springframework.web.servlet.mvc.delegation.ComponentUtils;
import org.shept.org.springframework.web.servlet.mvc.delegation.component.AbstractComponent;
import org.shept.org.springframework.web.servlet.mvc.delegation.component.WebComponent;
import org.shept.org.springframework.web.servlet.mvc.support.RequestValueUtils;
import org.springframework.web.servlet.ModelAndView;

public class PropertyEditorComponent
extends AbstractComponent
implements WebComponent {
    @Override
    public ModelAndView excecuteAction(HttpServletRequest request, HttpServletResponse response, ComponentToken token) throws Exception {
        return this.doActionInternal(request, token);
    }

    protected ModelAndView doActionInternal(HttpServletRequest request, ComponentToken token) throws Exception {
        String method = token.getToken().getMethod();
        Map<String, Object> properties = null;
        CommandWrapper wrapper = ComponentUtils.lookupComponentWrapper(token);
        if (wrapper == null) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error((Object)("Could not find the command wrapper. This is an internal programming error on token: " + token.toString()));
            }
            return this.modelUnhandled(request, token);
        }
        properties = wrapper.getProperties();
        RequestValueUtils.KeyValueParameter kvp = RequestValueUtils.getKeyValueParameter(token.getToken().getValue());
        if (method.equals("onPropertyReset")) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Property Reset operation: " + token.toString()));
            }
            properties.remove(kvp.getKey());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Property  " + kvp.getKey() + " successfully removed, Token: " + token.toString()));
            }
            return this.modelRedirect(request, token);
        }
        if (method.equals("onPropertySet")) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Property Set operation: " + token.toString()));
            }
            properties.put(kvp.getKey(), kvp.getValue());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Property  " + kvp.getKey() + " set to value " + kvp.getKey().toString() + " , Token: " + token.toString()));
            }
            return this.modelRedirect(request, token);
        }
        if (method.equals("onPropertyToggle")) {
            Object value = properties.get(kvp.getKey());
            if (value instanceof Boolean) {
                properties.put(kvp.getKey(), (Boolean)value == false);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Boolean value of property " + kvp.getKey() + " successfully toggled to " + ((Boolean)value == false) + " Token: " + token.toString()));
                }
            } else if (this.logger.isErrorEnabled()) {
                this.logger.error((Object)("Could not toggle Boolean value of property " + kvp.getKey() + " because value is not of type Boolean: " + token.toString()));
            }
            return this.modelRedirect(request, token);
        }
        return this.modelUnhandled(request, token);
    }

    @Override
    public Map<String, String> getDefaultMappings() {
        HashMap<String, String> mappings = new HashMap<String, String>();
        mappings.put("submitPropertyReset", "onPropertyReset");
        mappings.put("submitPropertySet", "onPropertySet");
        mappings.put("submitPropertyToggle", "onPropertyToggle");
        return mappings;
    }

    @Override
    public boolean supports(Object commandObject) {
        return true;
    }
}

