/*
 * Decompiled with CFR 0.152.
 */
package org.shept.org.springframework.web.servlet.mvc.delegation.configuration;

import java.util.List;
import org.shept.org.springframework.web.servlet.mvc.delegation.configuration.ChainConfigurationException;
import org.springframework.util.StringUtils;

public class ActionConfiguration {
    private boolean create = false;
    private boolean delete = false;
    private boolean update = false;

    public ActionConfiguration() {
    }

    public ActionConfiguration(List<String> actions) {
        for (String action : actions) {
            String cmp = StringUtils.trimWhitespace((String)action).toLowerCase();
            if (cmp.equals("c") || cmp.equals("create")) {
                this.create = true;
                continue;
            }
            if (cmp.equals("d") || cmp.equals("delete")) {
                this.delete = true;
                continue;
            }
            if (cmp.equals("u") || cmp.equals("update")) {
                this.update = true;
                continue;
            }
            throw new ChainConfigurationException("Action Configuration specifies invalid action: '" + action + "' Should be one or more of 'create', 'update', 'delete' ");
        }
    }

    public boolean isCreate() {
        return this.create;
    }

    public void setCreate(boolean create) {
        this.create = create;
    }

    public boolean isDelete() {
        return this.delete;
    }

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    public boolean isUpdate() {
        return this.update;
    }

    public void setUpdate(boolean update) {
        this.update = update;
    }
}

