/*
 * Decompiled with CFR 0.152.
 */
package org.shept.org.springframework.web.servlet.mvc.delegation.configuration;

import org.shept.org.springframework.web.servlet.mvc.delegation.command.AssociationCommandFactory;
import org.shept.org.springframework.web.servlet.mvc.delegation.command.CommandFactory;
import org.shept.org.springframework.web.servlet.mvc.delegation.command.EditItemCommandFactory;
import org.shept.org.springframework.web.servlet.mvc.delegation.command.RefreshableListCommandFactory;
import org.shept.org.springframework.web.servlet.mvc.delegation.configuration.DataGridConfiguration;
import org.shept.org.springframework.web.servlet.mvc.delegation.configuration.SegmentConfiguration;
import org.shept.org.springframework.web.servlet.mvc.delegation.configuration.TargetConfiguration;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class ChainConfiguration
extends TargetConfiguration
implements InitializingBean,
BeanNameAware {
    private SegmentConfiguration from;
    private String relation;

    @Override
    protected CommandFactory createCommandFactory() {
        AssociationCommandFactory acf = new AssociationCommandFactory();
        if (this.relation != null) {
            acf.setRelation(this.relation);
            return acf;
        }
        if (this.getFilterClass() != null) {
            return new RefreshableListCommandFactory();
        }
        if (this.getTo() instanceof DataGridConfiguration) {
            return acf;
        }
        return new EditItemCommandFactory();
    }

    protected CommandFactory createCommandFactory_old() {
        if (this.getTo() instanceof DataGridConfiguration) {
            if (this.relation != null || this.getFilterClass() == null) {
                AssociationCommandFactory acf = new AssociationCommandFactory();
                acf.setRelation(this.relation);
                return acf;
            }
            return new RefreshableListCommandFactory();
        }
        return new EditItemCommandFactory();
    }

    public SegmentConfiguration getFrom() {
        return this.from;
    }

    public void setFrom(SegmentConfiguration from) {
        this.from = from;
    }

    @Override
    public String getChainNameDisplay() {
        String name = "Chain";
        if (this.getBeanName() != null) {
            name = name + " " + this.getBeanName();
        }
        name = name + " ( from " + this.from.getBeanName() + " to " + this.getTo().getBeanName() + ")";
        return name;
    }

    public String getRelation() {
        return this.relation;
    }

    public void setRelation(String relation) {
        this.relation = relation;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.from);
        if (this.relation != null) {
            if (!this.relation.startsWith("get")) {
                this.relation = "get" + StringUtils.capitalize((String)this.relation);
            }
            Assert.notNull(this.from.getEntityClass(), (String)("Chain configuration for '" + this.getChainNameDisplay() + "' does not specify a source entity"));
            Assert.notNull((Object)ReflectionUtils.findMethod(this.from.getEntityClass(), (String)this.relation), (String)("Chain configuration for '" + this.getChainNameDisplay() + "' specifies an invalid relation ('" + this.relation + "')"));
        }
    }
}

