/*
 * Decompiled with CFR 0.152.
 */
package org.shept.org.springframework.web.servlet.mvc.delegation.configuration;

import java.util.Map;
import javax.persistence.Entity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.shept.beans.support.FilterDefinition;
import org.shept.org.springframework.web.bind.support.ComponentBindingInitializer;
import org.shept.org.springframework.web.bind.support.ComponentPostprocessor;
import org.shept.org.springframework.web.servlet.mvc.delegation.ComponentTransaction;
import org.shept.org.springframework.web.servlet.mvc.delegation.ComponentValidator;
import org.shept.org.springframework.web.servlet.mvc.delegation.configuration.ChainConfiguration;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;

public class SegmentConfiguration
implements BeanNameAware,
InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String name;
    private Class<?> entityClass;
    private Class<FilterDefinition> filterClass;
    private ComponentBindingInitializer[] componentBindingInitializers;
    private ComponentValidator[] validators;
    private ComponentTransaction transaction;
    private ComponentPostprocessor[] componentPostprocessors;
    private Map<String, ChainConfiguration> chains;

    public void setEntityClass(Class<?> entityClass) {
        this.entityClass = entityClass;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public Class<FilterDefinition> getFilterClass() {
        return this.filterClass;
    }

    public void setFilterClass(Class<FilterDefinition> filterClass) {
        this.filterClass = filterClass;
    }

    public ComponentBindingInitializer[] getComponentBindingInitializers() {
        return this.componentBindingInitializers;
    }

    public void setComponentBindingInitializers(ComponentBindingInitializer[] componentBindingInitializers) {
        this.componentBindingInitializers = componentBindingInitializers;
    }

    public void setComponentBindingInitializer(ComponentBindingInitializer componentBindingInitializer) {
        this.componentBindingInitializers = new ComponentBindingInitializer[]{componentBindingInitializer};
    }

    public ComponentValidator[] getValidators() {
        return this.validators;
    }

    public void setValidators(ComponentValidator[] validators) {
        this.validators = validators;
    }

    public void setValidator(ComponentValidator validator) {
        this.validators = new ComponentValidator[]{validator};
    }

    public void setBeanName(String name) {
        this.name = name;
    }

    public String getBeanName() {
        return this.name;
    }

    public ComponentPostprocessor[] getComponentPostprocessors() {
        return this.componentPostprocessors;
    }

    public void setComponentPostprocessors(ComponentPostprocessor[] componentPostprocessors) {
        this.componentPostprocessors = componentPostprocessors;
    }

    public void setComponentPostprocessor(ComponentPostprocessor componentPostprocessor) {
        this.componentPostprocessors = new ComponentPostprocessor[]{componentPostprocessor};
    }

    public ComponentTransaction getTransaction() {
        return this.transaction;
    }

    public void setTransaction(ComponentTransaction transaction) {
        this.transaction = transaction;
    }

    public Map<String, ChainConfiguration> getChains() {
        return this.chains;
    }

    public void setChains(Map<String, ChainConfiguration> chains) {
        this.chains = chains;
    }

    public void afterPropertiesSet() throws Exception {
        Class<FilterDefinition> ec = this.getEntityClass();
        if (ec != null) {
            Entity ann = (Entity)AnnotationUtils.findAnnotation(ec, Entity.class);
            Assert.notNull((Object)ann, (String)("Segment Configuration for Segment '" + this.getBeanName() + "' specifies Class '" + ec + "' which is not a vaild Entity class"));
            if (this.getFilterClass() == null && FilterDefinition.class.isAssignableFrom(ec)) {
                this.setFilterClass(ec);
            }
        }
    }
}

