/*
 * Decompiled with CFR 0.152.
 */
package org.shept.org.springframework.web.servlet.mvc.delegation.configuration;

import java.util.Arrays;
import javax.annotation.Resource;
import javax.persistence.Entity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.shept.beans.support.FilterDefinition;
import org.shept.org.springframework.web.servlet.mvc.delegation.command.AbstractCommandFactory;
import org.shept.org.springframework.web.servlet.mvc.delegation.command.CommandFactory;
import org.shept.org.springframework.web.servlet.mvc.delegation.command.RefreshableListCommandFactory;
import org.shept.org.springframework.web.servlet.mvc.delegation.configuration.ActionConfiguration;
import org.shept.org.springframework.web.servlet.mvc.delegation.configuration.SegmentConfiguration;
import org.shept.org.springframework.web.servlet.mvc.support.InfoItem;
import org.shept.util.PageHolderFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class TargetConfiguration
implements InitializingBean,
ApplicationContextAware,
BeanNameAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected ApplicationContext context;
    private String name;
    private Class<?> entityClass;
    private Class<FilterDefinition> filterClass;
    private String filterInitMethod;
    private SegmentConfiguration to;
    private CommandFactory commandFactory;
    private InfoItem info = new InfoItem();
    private PageHolderFactory pageHolderFactory;
    private String[] disabled = new String[0];
    private ActionConfiguration disabledActions = new ActionConfiguration();

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public void setEntityClass(Class<?> entityClass) {
        this.entityClass = entityClass;
    }

    public Class<FilterDefinition> getFilterClass() {
        return this.filterClass;
    }

    public void setFilterClass(Class<FilterDefinition> filterClass) {
        this.filterClass = filterClass;
    }

    public InfoItem getInfo() {
        return this.info;
    }

    public void setInfo(InfoItem info) {
        this.info = info;
    }

    public void setInfo(String code) {
        this.info = new InfoItem();
        this.info.setCode(code);
    }

    public SegmentConfiguration getTo() {
        return this.to;
    }

    public void setTo(SegmentConfiguration to) {
        this.to = to;
    }

    public CommandFactory getCommandFactory() {
        return this.commandFactory;
    }

    public void setCommandFactory(CommandFactory commandFactory) {
        this.commandFactory = commandFactory;
    }

    public String getBeanName() {
        return this.name;
    }

    public void setBeanName(String name) {
        this.name = name;
    }

    @Resource
    public void setPageHolderFactory(PageHolderFactory pageHolderFactory) {
        this.pageHolderFactory = pageHolderFactory;
    }

    public String getChainNameDisplay() {
        String name = "Chain";
        if (this.getBeanName() != null) {
            name = name + " " + this.getBeanName();
        }
        name = name + " to " + this.to.getBeanName();
        return name;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    protected CommandFactory createCommandFactory() {
        return new RefreshableListCommandFactory();
    }

    public String getFilterInitMethod() {
        return this.filterInitMethod;
    }

    public void setDisabled(String[] disabled) {
        this.disabled = disabled;
    }

    public ActionConfiguration getDisabledActions() {
        return this.disabledActions;
    }

    public void setDisabledActions(ActionConfiguration disabledActions) {
        this.disabledActions = disabledActions;
    }

    public void setFilterInitMethod(String filterInitMethod) {
        this.filterInitMethod = filterInitMethod;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.to);
        Assert.notNull((Object)this.to.getBeanName());
        if (this.entityClass == null) {
            this.entityClass = this.to.getEntityClass();
        }
        if (this.filterClass == null) {
            this.filterClass = this.to.getFilterClass();
        }
        Class<FilterDefinition> ec = this.entityClass;
        Class<FilterDefinition> fc = this.filterClass;
        if (ec != null) {
            Entity ann = (Entity)AnnotationUtils.findAnnotation(ec, Entity.class);
            Assert.notNull((Object)ann, (String)("Chain Configuration for '" + this.getChainNameDisplay() + "' specifies Class '" + this.getEntityClass() + "' which is not a vaild Entity class"));
            if (fc == null && FilterDefinition.class.isAssignableFrom(ec)) {
                this.setFilterClass(ec);
            }
            this.logger.info((Object)(this.getClass().getSimpleName() + " " + this.getChainNameDisplay() + " for entity class '" + this.entityClass + "'"));
        }
        if (fc != null) {
            if (this.filterInitMethod != null) {
                Assert.notNull((Object)ReflectionUtils.findMethod(this.getFilterClass(), (String)this.filterInitMethod), (String)("Chain configuration for '" + this.getChainNameDisplay() + "' specifies an invalid filter initialization ('" + this.filterInitMethod + "') for filter class '" + this.filterClass + "'"));
            }
            this.logger.info((Object)(this.getClass().getSimpleName() + " " + this.getChainNameDisplay() + " for filter class '" + this.filterClass + "'"));
        }
        if (this.commandFactory == null) {
            Assert.notNull((Object)this.pageHolderFactory, (String)(this.getClass().getSimpleName() + " " + this.getChainNameDisplay() + " has neither commandFactory nor a pageHolderFactory defined. You need to declare one of both"));
            this.commandFactory = this.createCommandFactory();
            if (this.commandFactory instanceof AbstractCommandFactory) {
                AbstractCommandFactory acf = (AbstractCommandFactory)this.commandFactory;
                acf.setPageHolderFactory(this.pageHolderFactory);
                acf.setApplicationContext(this.context);
            }
        }
        this.setDisabledActions(new ActionConfiguration(Arrays.asList(this.disabled)));
    }
}

