/*
 * Decompiled with CFR 0.152.
 */
package org.shept.org.springframework.web.servlet.mvc.formcache;

import java.util.Calendar;
import javax.servlet.http.HttpServletRequest;
import org.shept.org.springframework.web.servlet.mvc.formcache.SimpleSessionFormCache;
import org.shept.util.HelperUtils;
import org.springframework.util.StringUtils;

public class LastModifiedSessionFormCache
extends SimpleSessionFormCache {
    @Override
    public void saveForm(HttpServletRequest request, String formAttrName, Object command) {
        WrappedObject wrapped = new WrappedObject();
        wrapped.setFormObject(command);
        super.saveForm(request, formAttrName, wrapped);
    }

    @Override
    public Object getForm(HttpServletRequest request, String formAttrName) {
        WrappedObject wrapped = (WrappedObject)super.getForm(request, formAttrName);
        return wrapped == null ? null : wrapped.getFormObject();
    }

    @Override
    public long getLastModified(HttpServletRequest request, String formAttrName) {
        try {
            WrappedObject wrapped = (WrappedObject)super.getForm(request, formAttrName);
            if (wrapped == null) {
                this.logger.warn((Object)"Checksum not calculated, no wrapped command object found");
                return -1L;
            }
            String checksum = this.calculateChecksum(wrapped.getFormObject());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Calculated checksum is " + checksum));
            }
            if (!StringUtils.hasText((String)checksum)) {
                return -1L;
            }
            if (checksum.equals(wrapped.getChecksum())) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Calculated checksum equals to old checksum");
                }
                return wrapped.getLastModified();
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Checksum and LastModified set to new value");
            }
            wrapped.setChecksum(checksum);
            wrapped.touchLastModified();
            return wrapped.getLastModified();
        }
        catch (Exception ex) {
            return -1L;
        }
    }

    protected String calculateChecksum(Object object) {
        try {
            byte[] stream = HelperUtils.serialize(object);
            return String.valueOf(stream.hashCode());
        }
        catch (Exception ex) {
            this.logger.error((Object)("Error while serializing the command object " + object.toString()), (Throwable)ex);
            return "";
        }
    }

    public class WrappedObject {
        private Object formObject;
        private long lastModified = -1L;
        private String checksum = "";

        public Object getFormObject() {
            return this.formObject;
        }

        public void setFormObject(Object formObject) {
            this.formObject = formObject;
            String checksum = LastModifiedSessionFormCache.this.calculateChecksum(formObject);
            this.setChecksum(checksum);
            this.touchLastModified();
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public void setLastModified(long lastModified) {
            this.lastModified = lastModified;
        }

        public String getChecksum() {
            return this.checksum;
        }

        public void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        public void touchLastModified() {
            Calendar cal = Calendar.getInstance();
            cal.set(14, 0);
            this.lastModified = cal.getTime().getTime();
        }
    }
}

