/*
 * Decompiled with CFR 0.152.
 */
package org.shept.org.springframework.web.servlet.mvc.formcache;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.shept.org.springframework.web.servlet.mvc.formcache.SessionFormCache;
import org.shept.org.springframework.web.servlet.mvc.formcache.SessionFormCacheException;
import org.springframework.web.context.support.WebApplicationObjectSupport;

public class SimpleSessionFormCache
extends WebApplicationObjectSupport
implements SessionFormCache {
    public static String SESSION_FORM_CACHE_ATTIRBUTE = "sessionFormCacheAttribute";
    public static int MAX_CACHE_SIZE = 5;
    private int maxCacheSize = MAX_CACHE_SIZE;

    public void clearForm(HttpServletRequest request, String formAttrName) throws Exception {
        Map<String, Object> cache = this.getFormCache(request, false, false);
        if (cache == null) {
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Removing form form from session cache [" + formAttrName + "]"));
        }
        cache.remove(formAttrName);
    }

    public void clearOtherForms(HttpServletRequest request, String formAttrName) throws Exception {
        Map<String, Object> cache = this.getFormCache(request, false, false);
        if (cache == null) {
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Removing all forms from session cache except [" + formAttrName + "]"));
        }
        for (String key : cache.keySet()) {
            if (key.equals(formAttrName)) continue;
            cache.remove(key);
        }
    }

    @Override
    public void clearCache(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Removing the cache from the session");
            }
            session.removeAttribute(SESSION_FORM_CACHE_ATTIRBUTE);
        }
    }

    protected Map<String, Object> getFormCache(HttpServletRequest request, boolean required, boolean create) {
        HttpSession session = request.getSession(create);
        if (session == null) {
            if (!required) {
                return null;
            }
            throw new SessionFormCacheException("Must have session when trying to bind (in session-form mode)");
        }
        SizeLimitedCache cache = (SizeLimitedCache)session.getAttribute(SESSION_FORM_CACHE_ATTIRBUTE);
        if (cache == null) {
            cache = new SizeLimitedCache();
            session.setAttribute(SESSION_FORM_CACHE_ATTIRBUTE, cache);
        }
        return cache;
    }

    @Override
    public long getLastModified(HttpServletRequest request, String formAttrName) {
        return -1L;
    }

    @Override
    public void saveForm(HttpServletRequest request, String formAttrName, Object command) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Caching form in session [" + formAttrName + "] to: " + command));
        }
        Map<String, Object> cache = this.getFormCache(request, true, true);
        if (command != null) {
            cache.put(formAttrName, command);
        } else {
            cache.remove(formAttrName);
        }
    }

    @Override
    public Object getForm(HttpServletRequest request, String formAttrName) {
        Map<String, Object> cache = this.getFormCache(request, false, false);
        if (cache == null) {
            return null;
        }
        Object sessionFormObject = cache.get(formAttrName);
        if (sessionFormObject == null) {
            return null;
        }
        return sessionFormObject;
    }

    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public void setMaxCacheSize(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
    }

    private class SizeLimitedCache<String, Object>
    extends LinkedHashMap<String, Object> {
        private static final long serialVersionUID = 1L;

        private SizeLimitedCache() {
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Object> eldest) {
            if (this.size() > SimpleSessionFormCache.this.maxCacheSize) {
                if (SimpleSessionFormCache.this.logger.isDebugEnabled()) {
                    SimpleSessionFormCache.this.logger.debug((Object)("Removing eldest cached form from session [" + eldest.getKey() + "]"));
                }
                return true;
            }
            return false;
        }
    }
}

