/*
 * Decompiled with CFR 0.152.
 */
package org.shept.org.springframework.web.servlet.mvc.interceptors;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class EnumExposureHandlerInterceptor
extends HandlerInterceptorAdapter {
    private Set<Class<? extends Enum>> enumClasses = new HashSet<Class<? extends Enum>>();

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        for (Class<? extends Enum> enumClass : this.enumClasses) {
            String enumClassName = enumClass.getSimpleName();
            Enum[] enums = enumClass.getEnumConstants();
            HashMap<String, Enum> map = new HashMap<String, Enum>(enums.length);
            for (Enum anEnum : enums) {
                map.put(anEnum.name(), anEnum);
            }
            request.setAttribute(enumClassName, map);
        }
    }

    public void setEnumClasses(Set<Class<? extends Enum>> enumClasses) {
        this.enumClasses = enumClasses;
    }
}

