/*
 * Decompiled with CFR 0.152.
 */
package org.shept.org.springframework.web.servlet.mvc.interceptors;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.validation.BindingResult;
import org.springframework.validation.BindingResultUtils;
import org.springframework.validation.ObjectError;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import org.springframework.web.servlet.support.RequestContext;
import org.springframework.web.servlet.view.RedirectView;

public class FormCompletionInterceptor
extends HandlerInterceptorAdapter {
    public static final String ERROR_MSG = "formErrorMessage";

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        if (modelAndView == null || modelAndView.getView() instanceof RedirectView) {
            return;
        }
        RequestContext rc = new RequestContext(request);
        BindingResult res = null;
        for (String name : modelAndView.getModel().keySet()) {
            if (!name.startsWith(BindingResult.MODEL_KEY_PREFIX)) continue;
            res = BindingResultUtils.getBindingResult((Map)modelAndView.getModel(), (String)name.substring(BindingResult.MODEL_KEY_PREFIX.length()));
        }
        HashMap<String, String> controlModel = new HashMap<String, String>();
        String errStr = "";
        if (res != null && res.hasErrors()) {
            List errList = res.getAllErrors();
            Iterator it = errList.iterator();
            if (it.hasNext()) {
                ObjectError error = (ObjectError)it.next();
                String myErrCode = error.getCode();
                for (String eStr : error.getCodes()) {
                    String errMsg = rc.getMessage(eStr, "");
                    if (errMsg.length() <= 0) continue;
                    myErrCode = eStr;
                    break;
                }
                errStr = errStr + rc.getMessage(myErrCode, error.getArguments(), error.getDefaultMessage());
            }
            if (it.hasNext()) {
                errStr = errStr + "  ...";
            }
        }
        controlModel.put(ERROR_MSG, errStr);
        modelAndView.addAllObjects(controlModel);
    }
}

